/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import com.google.gson.JsonObject;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import org.jetbrains.annotations.NotNull;

public class ArmorUpgradeRecipe
extends ShapedRecipe {
    public static final RecipeSerializer<ArmorUpgradeRecipe> SERIALIZER = new Serializer();

    public ArmorUpgradeRecipe(ShapedRecipe compose) {
        super(compose.getId(), compose.getGroup(), compose.category(), compose.getWidth(), compose.getHeight(), compose.getIngredients(), compose.getResultItem((RegistryAccess)RegistryAccess.EMPTY));
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingContainer inv, @NotNull RegistryAccess registries) {
        ItemStack out = super.assemble(inv, registries);
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (!stack.hasTag() || !(stack.getItem() instanceof ArmorItem)) continue;
            out.setTag(stack.getTag());
            break;
        }
        return out;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    private static class Serializer
    implements RecipeSerializer<ArmorUpgradeRecipe> {
        private Serializer() {
        }

        public ArmorUpgradeRecipe fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
            return new ArmorUpgradeRecipe((ShapedRecipe)SHAPED_RECIPE.fromJson(recipeId, json));
        }

        public ArmorUpgradeRecipe fromNetwork(@NotNull ResourceLocation recipeId, @NotNull FriendlyByteBuf buffer) {
            return new ArmorUpgradeRecipe((ShapedRecipe)SHAPED_RECIPE.fromNetwork(recipeId, buffer));
        }

        public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull ArmorUpgradeRecipe recipe) {
            SHAPED_RECIPE.toNetwork(buffer, (Recipe)recipe);
        }
    }
}

