/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.recipe.ElvenTradeRecipe;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.BotaniaItems;

public class LexiconElvenTradeRecipe
implements ElvenTradeRecipe {
    private final ResourceLocation id;

    LexiconElvenTradeRecipe(ResourceLocation id) {
        this.id = id;
    }

    @Override
    public boolean containsItem(ItemStack stack) {
        return stack.is((Item)BotaniaItems.lexicon) && !ItemNBTHelper.getBoolean(stack, "botania:elven_unlock", false);
    }

    @Override
    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        return NonNullList.withSize((int)1, (Object)Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.lexicon}));
    }

    @NotNull
    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)BotaniaBlocks.alfPortal);
    }

    @NotNull
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public List<ItemStack> getOutputs() {
        ItemStack stack = new ItemStack((ItemLike)BotaniaItems.lexicon);
        stack.getOrCreateTag().putBoolean("botania:elven_unlock", true);
        return Collections.singletonList(stack);
    }

    @Override
    public Optional<List<ItemStack>> match(List<ItemStack> stacks) {
        for (ItemStack stack : stacks) {
            if (!this.containsItem(stack)) continue;
            return Optional.of(Collections.singletonList(stack));
        }
        return Optional.empty();
    }

    @Override
    public List<ItemStack> getOutputs(List<ItemStack> inputs) {
        ItemStack stack = inputs.get(0).copy();
        stack.getOrCreateTag().putBoolean("botania:elven_unlock", true);
        return Collections.singletonList(stack);
    }

    @NotNull
    public RecipeSerializer<LexiconElvenTradeRecipe> getSerializer() {
        return BotaniaRecipeTypes.LEXICON_ELVEN_TRADE_SERIALIZER;
    }
}

