/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.block_entity;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.level.storage.ServerLevelData;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntity;

public class TeruTeruBozuBlockEntity
extends BotaniaBlockEntity {
    private boolean wasRaining = false;

    public TeruTeruBozuBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaBlockEntities.TERU_TERU_BOZU, pos, state);
    }

    public static void serverTick(Level level, BlockPos worldPosition, BlockState state, TeruTeruBozuBlockEntity self) {
        boolean isRaining = level.isRaining();
        if (isRaining && level.random.nextInt(9600) == 0) {
            level.getLevelData().setRaining(false);
            TeruTeruBozuBlockEntity.resetRainTime(level);
        }
        if (self.wasRaining != isRaining) {
            level.updateNeighbourForOutputSignal(worldPosition, state.getBlock());
        }
        self.wasRaining = isRaining;
    }

    public static void resetRainTime(Level w) {
        int time = w.random.nextInt(w.getLevelData().isRaining() ? 12000 : 168000) + 12000;
        LevelData info = w.getLevelData();
        if (info instanceof ServerLevelData) {
            ServerLevelData serverInfo = (ServerLevelData)info;
            serverInfo.setRainTime(time);
        }
    }
}

