/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.block_entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Objects;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.mana.PoolOverlayProvider;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.block.block_entity.mana.ManaPoolBlockEntity;
import vazkii.botania.common.block.mana.ManaPoolBlock;
import vazkii.botania.common.helper.ColorHelper;
import vazkii.botania.common.helper.MathHelper;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class ManaPoolBlockEntityRenderer
implements BlockEntityRenderer<ManaPoolBlockEntity> {
    public static int cartMana = -1;
    private final TextureAtlasSprite waterSprite;
    private final BlockRenderDispatcher blockRenderDispatcher;

    public ManaPoolBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        this.blockRenderDispatcher = ctx.getBlockRenderDispatcher();
        this.waterSprite = Objects.requireNonNull((TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(ResourceLocationHelper.prefix("block/mana_water")));
    }

    public void render(@Nullable ManaPoolBlockEntity pool, float f, PoseStack ms, MultiBufferSource buffers, int light, int overlay) {
        float manaLevel;
        int maxMana;
        Block below;
        ms.pushPose();
        boolean fab = pool != null && ((ManaPoolBlock)pool.getBlockState().getBlock()).variant == ManaPoolBlock.Variant.FABULOUS;
        boolean diluted = pool != null && ((ManaPoolBlock)pool.getBlockState().getBlock()).variant == ManaPoolBlock.Variant.DILUTED;
        boolean creative = pool != null && ((ManaPoolBlock)pool.getBlockState().getBlock()).variant == ManaPoolBlock.Variant.CREATIVE;
        int insideUVStart = diluted ? 1 : 2;
        int insideUVEnd = 16 - insideUVStart;
        float poolBottom = (float)insideUVStart / 16.0f + 0.001f;
        float poolTop = (float)(diluted ? 5 : (creative ? 9 : 7)) / 16.0f;
        if (fab) {
            float time = (float)ClientTickHandler.ticksInGame + ClientTickHandler.partialTicks;
            time += (float)new Random(pool.getBlockPos().getX() ^ pool.getBlockPos().getY() ^ pool.getBlockPos().getZ()).nextInt(100000);
            int poolColor = pool.getColor().map(ColorHelper::getColorValue).orElse(-1);
            int color = MathHelper.multiplyColor(Mth.hsvToRgb((float)Mth.frac((float)(time *= 0.005f)), (float)0.6f, (float)1.0f), poolColor);
            int red = (color & 0xFF0000) >> 16;
            int green = (color & 0xFF00) >> 8;
            int blue = color & 0xFF;
            BlockState state = pool.getBlockState();
            BakedModel model = this.blockRenderDispatcher.getBlockModel(state);
            VertexConsumer buffer = buffers.getBuffer(ItemBlockRenderTypes.getRenderType((BlockState)state, (boolean)false));
            this.blockRenderDispatcher.getModelRenderer().renderModel(ms.last(), buffer, state, model, (float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f, light, overlay);
        }
        if (pool != null && (below = pool.getLevel().getBlockState(pool.getBlockPos().below()).getBlock()) instanceof PoolOverlayProvider) {
            PoolOverlayProvider overlayProvider = (PoolOverlayProvider)below;
            ResourceLocation overlaySpriteId = overlayProvider.getIcon(pool.getLevel(), pool.getBlockPos());
            TextureAtlasSprite overlayIcon = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(overlaySpriteId);
            ms.pushPose();
            float alpha = (float)((Math.sin((double)((float)ClientTickHandler.ticksInGame + f) / 20.0) + 1.0) * 0.3 + 0.2);
            ms.translate(0.0f, poolBottom, 0.0f);
            ms.mulPose(VecHelper.rotateX(90.0f));
            VertexConsumer buffer = buffers.getBuffer(RenderHelper.ICON_OVERLAY);
            RenderHelper.renderIconCropped(ms, buffer, insideUVStart, insideUVStart, insideUVEnd, insideUVEnd, overlayIcon, 0xFFFFFF, alpha, light);
            ms.popPose();
        }
        int mana = pool == null ? cartMana : pool.getCurrentMana();
        int n = maxMana = pool == null ? -1 : pool.getMaxMana();
        if (maxMana == -1) {
            maxMana = 1000000;
        }
        if ((manaLevel = (float)mana / (float)maxMana) > 0.0f) {
            ms.pushPose();
            ms.translate(0.0f, Mth.clampedMap((float)manaLevel, (float)0.0f, (float)1.0f, (float)poolBottom, (float)poolTop), 0.0f);
            ms.mulPose(VecHelper.rotateX(90.0f));
            VertexConsumer buffer = buffers.getBuffer(RenderHelper.MANA_POOL_WATER);
            RenderHelper.renderIconCropped(ms, buffer, insideUVStart, insideUVStart, insideUVEnd, insideUVEnd, this.waterSprite, 0xFFFFFF, 1.0f, light);
            ms.popPose();
        }
        ms.popPose();
        cartMana = -1;
    }
}

