/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.block_entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.block.block_entity.CocoonBlockEntity;
import vazkii.botania.common.helper.VecHelper;

public class CocoonBlockEntityRenderer
implements BlockEntityRenderer<CocoonBlockEntity> {
    private final BlockRenderDispatcher blockRenderDispatcher;

    public CocoonBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        this.blockRenderDispatcher = ctx.getBlockRenderDispatcher();
    }

    public void render(@NotNull CocoonBlockEntity cocoon, float partialTicks, PoseStack ms, MultiBufferSource buffers, int light, int overlay) {
        float rot = 0.0f;
        float modval = 60.0f - (float)cocoon.timePassed / 2400.0f * 30.0f;
        if ((float)cocoon.timePassed % modval < 10.0f) {
            float mod = ((float)cocoon.timePassed + partialTicks) % modval;
            float v = mod / 5.0f * (float)Math.PI * 2.0f;
            rot = (float)Math.sin(v) * (float)Math.log((float)cocoon.timePassed + partialTicks);
        }
        ms.pushPose();
        ms.translate(0.5, 0.0, 0.0);
        ms.mulPose(VecHelper.rotateX(rot));
        ms.translate(-0.5, 0.0, 0.0);
        BlockState state = cocoon.getBlockState();
        BakedModel model = this.blockRenderDispatcher.getBlockModel(state);
        VertexConsumer buffer = buffers.getBuffer(ItemBlockRenderTypes.getChunkRenderType((BlockState)state));
        this.blockRenderDispatcher.getModelRenderer().renderModel(ms.last(), buffer, state, model, 1.0f, 1.0f, 1.0f, light, overlay);
        ms.popPose();
    }
}

