/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data.recipes;

import com.google.gson.JsonObject;
import java.util.function.Consumer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.Nullable;

public class WrapperResult
implements FinishedRecipe {
    private final FinishedRecipe delegate;
    @Nullable
    private final RecipeSerializer<?> type;
    @Nullable
    private final Consumer<JsonObject> transform;

    public static Consumer<FinishedRecipe> ofType(RecipeSerializer<?> type, Consumer<FinishedRecipe> parent) {
        return recipe -> parent.accept(new WrapperResult((FinishedRecipe)recipe, type, null));
    }

    public static Consumer<FinishedRecipe> transformJson(Consumer<FinishedRecipe> parent, Consumer<JsonObject> transform) {
        return recipe -> parent.accept(new WrapperResult((FinishedRecipe)recipe, null, transform));
    }

    private WrapperResult(FinishedRecipe delegate, @Nullable RecipeSerializer<?> type, @Nullable Consumer<JsonObject> transform) {
        this.delegate = delegate;
        this.type = type;
        this.transform = transform;
    }

    public void serializeRecipeData(JsonObject json) {
        this.delegate.serializeRecipeData(json);
        if (this.transform != null) {
            this.transform.accept(json);
        }
    }

    public JsonObject serializeRecipe() {
        if (this.type == null) {
            return super.serializeRecipe();
        }
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty("type", BuiltInRegistries.RECIPE_SERIALIZER.getKey(this.type).toString());
        this.serializeRecipeData(jsonobject);
        return jsonobject;
    }

    public ResourceLocation getId() {
        return this.delegate.getId();
    }

    public RecipeSerializer<?> getType() {
        return this.type != null ? this.type : this.delegate.getType();
    }

    @Nullable
    public JsonObject serializeAdvancement() {
        return this.delegate.serializeAdvancement();
    }

    @Nullable
    public ResourceLocation getAdvancementId() {
        return this.delegate.getAdvancementId();
    }
}

