/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data.recipes;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.lib.LibBlockNames;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.data.recipes.BotaniaRecipeProvider;

public class StonecuttingProvider
extends BotaniaRecipeProvider {
    public StonecuttingProvider(PackOutput packOutput) {
        super(packOutput);
    }

    @Override
    public void buildRecipes(Consumer<FinishedRecipe> consumer) {
        for (String variant : LibBlockNames.METAMORPHIC_VARIANTS) {
            this.registerForMetamorphic(variant, consumer);
        }
        for (String color : LibBlockNames.PAVEMENT_VARIANTS) {
            this.registerForPavement(color, consumer);
        }
        for (String variant : LibBlockNames.QUARTZ_VARIANTS) {
            this.registerForQuartz(variant, consumer);
        }
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.livingrock, (ItemLike)BotaniaBlocks.livingrockSlab, 2));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.livingrock, (ItemLike)BotaniaBlocks.livingrockStairs));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.livingrock, (ItemLike)BotaniaBlocks.livingrockWall));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.livingrock, (ItemLike)BotaniaBlocks.livingrockPolished));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.livingrock, (ItemLike)BotaniaBlocks.livingrockPolishedSlab, 2));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.livingrock, (ItemLike)BotaniaBlocks.livingrockPolishedStairs));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.livingrock, (ItemLike)BotaniaBlocks.livingrockPolishedWall));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.livingrock, (ItemLike)BotaniaBlocks.livingrockBrick));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.livingrock, (ItemLike)BotaniaBlocks.livingrockBrickSlab, 2));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.livingrock, (ItemLike)BotaniaBlocks.livingrockBrickStairs));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.livingrock, (ItemLike)BotaniaBlocks.livingrockBrickWall));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.livingrock, (ItemLike)BotaniaBlocks.livingrockBrickChiseled));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.livingrock, (ItemLike)BotaniaBlocks.livingrockSlate));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.livingrockPolished, (ItemLike)BotaniaBlocks.livingrockPolishedSlab, 2));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.livingrockPolished, (ItemLike)BotaniaBlocks.livingrockPolishedStairs));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.livingrockPolished, (ItemLike)BotaniaBlocks.livingrockPolishedWall));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.livingrockPolished, (ItemLike)BotaniaBlocks.livingrockBrick));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.livingrockPolished, (ItemLike)BotaniaBlocks.livingrockBrickSlab, 2));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.livingrockPolished, (ItemLike)BotaniaBlocks.livingrockBrickStairs));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.livingrockPolished, (ItemLike)BotaniaBlocks.livingrockBrickWall));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.livingrockPolished, (ItemLike)BotaniaBlocks.livingrockBrickChiseled));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.livingrockBrick, (ItemLike)BotaniaBlocks.livingrockBrickSlab, 2));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.livingrockBrick, (ItemLike)BotaniaBlocks.livingrockBrickStairs));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.livingrockBrick, (ItemLike)BotaniaBlocks.livingrockBrickWall));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.livingrockBrick, (ItemLike)BotaniaBlocks.livingrockBrickChiseled));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.livingrockBrickMossy, (ItemLike)BotaniaBlocks.livingrockBrickMossySlab, 2));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.livingrockBrickMossy, (ItemLike)BotaniaBlocks.livingrockBrickMossyStairs));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.livingrockBrickMossy, (ItemLike)BotaniaBlocks.livingrockBrickMossyWall));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.shimmerrock, (ItemLike)BotaniaBlocks.shimmerrockSlab, 2));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.shimmerrock, (ItemLike)BotaniaBlocks.shimmerrockStairs));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.corporeaBlock, (ItemLike)BotaniaBlocks.corporeaSlab, 2));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.corporeaBlock, (ItemLike)BotaniaBlocks.corporeaStairs));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.corporeaBlock, (ItemLike)BotaniaBlocks.corporeaBrick));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.corporeaBlock, (ItemLike)BotaniaBlocks.corporeaBrickSlab, 2));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.corporeaBlock, (ItemLike)BotaniaBlocks.corporeaBrickStairs));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.corporeaBlock, (ItemLike)BotaniaBlocks.corporeaBrickWall));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.corporeaBrick, (ItemLike)BotaniaBlocks.corporeaBrickSlab, 2));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.corporeaBrick, (ItemLike)BotaniaBlocks.corporeaBrickStairs));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.corporeaBrick, (ItemLike)BotaniaBlocks.corporeaBrickWall));
        List allAzulejos = IntStream.range(0, 16).mapToObj(i -> "azulejo_" + i).map(ResourceLocationHelper::prefix).map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).get(arg_0)).collect(Collectors.toList());
        for (Item azulejo : allAzulejos) {
            consumer.accept(this.anyToAnyStonecutting(allAzulejos, (ItemLike)azulejo));
        }
    }

    private void registerForQuartz(String variant, Consumer<FinishedRecipe> consumer) {
        Block base = (Block)BuiltInRegistries.BLOCK.get(this.prefix(variant));
        Block slab = (Block)BuiltInRegistries.BLOCK.get(this.prefix(variant + "_slab"));
        Block stairs = (Block)BuiltInRegistries.BLOCK.get(this.prefix(variant + "_stairs"));
        Block chiseled = (Block)BuiltInRegistries.BLOCK.get(this.prefix("chiseled_" + variant));
        Block pillar = (Block)BuiltInRegistries.BLOCK.get(this.prefix(variant + "_pillar"));
        consumer.accept(this.stonecutting((ItemLike)base, (ItemLike)slab, 2));
        consumer.accept(this.stonecutting((ItemLike)base, (ItemLike)stairs));
        consumer.accept(this.stonecutting((ItemLike)base, (ItemLike)chiseled));
        consumer.accept(this.stonecutting((ItemLike)base, (ItemLike)pillar));
    }

    private void registerForPavement(String color, Consumer<FinishedRecipe> consumer) {
        Block base = (Block)BuiltInRegistries.BLOCK.get(this.prefix(color + "_pavement"));
        Block slab = (Block)BuiltInRegistries.BLOCK.get(this.prefix(color + "_pavement_slab"));
        Block stair = (Block)BuiltInRegistries.BLOCK.get(this.prefix(color + "_pavement_stairs"));
        consumer.accept(this.stonecutting((ItemLike)base, (ItemLike)slab, 2));
        consumer.accept(this.stonecutting((ItemLike)base, (ItemLike)stair));
    }

    private void registerForMetamorphic(String variant, Consumer<FinishedRecipe> consumer) {
        Block base = (Block)BuiltInRegistries.BLOCK.get(this.prefix("metamorphic_" + variant + "_stone"));
        Block slab = (Block)BuiltInRegistries.BLOCK.get(this.prefix("metamorphic_" + variant + "_stone_slab"));
        Block stair = (Block)BuiltInRegistries.BLOCK.get(this.prefix("metamorphic_" + variant + "_stone_stairs"));
        Block wall = (Block)BuiltInRegistries.BLOCK.get(this.prefix("metamorphic_" + variant + "_stone_wall"));
        Block brick = (Block)BuiltInRegistries.BLOCK.get(this.prefix("metamorphic_" + variant + "_bricks"));
        Block brickSlab = (Block)BuiltInRegistries.BLOCK.get(this.prefix("metamorphic_" + variant + "_bricks_slab"));
        Block brickStair = (Block)BuiltInRegistries.BLOCK.get(this.prefix("metamorphic_" + variant + "_bricks_stairs"));
        Block brickWall = (Block)BuiltInRegistries.BLOCK.get(this.prefix("metamorphic_" + variant + "_bricks_wall"));
        Block chiseledBrick = (Block)BuiltInRegistries.BLOCK.get(this.prefix("chiseled_metamorphic_" + variant + "_bricks"));
        Block cobble = (Block)BuiltInRegistries.BLOCK.get(this.prefix("metamorphic_" + variant + "_cobblestone"));
        Block cobbleSlab = (Block)BuiltInRegistries.BLOCK.get(this.prefix("metamorphic_" + variant + "_cobblestone_slab"));
        Block cobbleStair = (Block)BuiltInRegistries.BLOCK.get(this.prefix("metamorphic_" + variant + "_cobblestone_stairs"));
        Block cobbleWall = (Block)BuiltInRegistries.BLOCK.get(this.prefix("metamorphic_" + variant + "_cobblestone_wall"));
        consumer.accept(this.stonecutting((ItemLike)base, (ItemLike)slab, 2));
        consumer.accept(this.stonecutting((ItemLike)base, (ItemLike)stair));
        consumer.accept(this.stonecutting((ItemLike)base, (ItemLike)wall));
        consumer.accept(this.stonecutting((ItemLike)base, (ItemLike)brick));
        consumer.accept(this.stonecutting((ItemLike)base, (ItemLike)brickSlab, 2));
        consumer.accept(this.stonecutting((ItemLike)base, (ItemLike)brickStair));
        consumer.accept(this.stonecutting((ItemLike)base, (ItemLike)brickWall));
        consumer.accept(this.stonecutting((ItemLike)base, (ItemLike)chiseledBrick));
        consumer.accept(this.stonecutting((ItemLike)brick, (ItemLike)brickSlab, 2));
        consumer.accept(this.stonecutting((ItemLike)brick, (ItemLike)brickStair));
        consumer.accept(this.stonecutting((ItemLike)brick, (ItemLike)brickWall));
        consumer.accept(this.stonecutting((ItemLike)brick, (ItemLike)chiseledBrick));
        consumer.accept(this.stonecutting((ItemLike)cobble, (ItemLike)cobbleSlab, 2));
        consumer.accept(this.stonecutting((ItemLike)cobble, (ItemLike)cobbleStair));
        consumer.accept(this.stonecutting((ItemLike)cobble, (ItemLike)cobbleWall));
    }

    @NotNull
    public String getName() {
        return "Botania stonecutting recipes";
    }

    protected ResourceLocation idFor(ItemLike a, ItemLike b) {
        ResourceLocation aId = BuiltInRegistries.ITEM.getKey((Object)a.asItem());
        ResourceLocation bId = BuiltInRegistries.ITEM.getKey((Object)b.asItem());
        return this.prefix("stonecutting/" + aId.getPath() + "_to_" + bId.getPath());
    }

    protected FinishedRecipe stonecutting(ItemLike input, ItemLike output) {
        return this.stonecutting(input, output, 1);
    }

    protected FinishedRecipe stonecutting(ItemLike input, ItemLike output, int count) {
        return new Result(this.idFor(input, output), RecipeSerializer.STONECUTTER, Ingredient.of((ItemLike[])new ItemLike[]{input}), output.asItem(), count);
    }

    protected FinishedRecipe anyToAnyStonecutting(List<? extends ItemLike> inputs, ItemLike output) {
        Ingredient input = Ingredient.of((ItemLike[])((ItemLike[])inputs.stream().filter(obj -> output != obj).toArray(ItemLike[]::new)));
        return new Result(this.prefix("stonecutting/" + BuiltInRegistries.ITEM.getKey((Object)output.asItem()).getPath()), RecipeSerializer.STONECUTTER, input, output.asItem(), 1);
    }

    protected ResourceLocation prefix(String path) {
        return ResourceLocationHelper.prefix(path);
    }

    public static class Result
    extends SingleItemRecipeBuilder.Result {
        public Result(ResourceLocation id, RecipeSerializer<?> serializer, Ingredient input, Item result, int count) {
            super(id, serializer, "", input, result, count, null, null);
        }

        @Nullable
        public JsonObject serializeAdvancement() {
            return null;
        }

        @Nullable
        public ResourceLocation getAdvancementId() {
            return null;
        }
    }
}

