/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.item.Relic;
import vazkii.botania.common.loot.BotaniaLootModifiers;
import vazkii.botania.xplat.XplatAbstractions;

public class BindUuid
extends LootItemConditionalFunction {
    protected BindUuid(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @NotNull
    public ItemStack run(@NotNull ItemStack stack, @NotNull LootContext context) {
        Object object = context.getParamOrNull(LootContextParams.KILLER_ENTITY);
        if (object instanceof Player) {
            Player player = (Player)object;
            Relic relic = XplatAbstractions.INSTANCE.findRelic(stack);
            if (relic != null) {
                relic.bindToUUID(player.getUUID());
            }
        }
        return stack;
    }

    public LootItemFunctionType getType() {
        return BotaniaLootModifiers.BIND_UUID;
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<BindUuid> {
        @NotNull
        public BindUuid deserialize(@NotNull JsonObject object, @NotNull JsonDeserializationContext deserializationContext, @NotNull LootItemCondition[] conditionsIn) {
            return new BindUuid(conditionsIn);
        }
    }
}

