/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.lens;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.HitResult;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.lens.Lens;

public class CelebratoryLens
extends Lens {
    @Override
    public boolean collideBurst(ManaBurst burst, HitResult pos, boolean isManaBlock, boolean shouldKill, ItemStack stack) {
        ThrowableProjectile entity = burst.entity();
        if (pos.getType() == HitResult.Type.BLOCK) {
            if (!(entity.level().isClientSide || burst.isFake() || isManaBlock)) {
                ItemStack fireworkStack = this.generateFirework(burst.getColor());
                FireworkRocketEntity rocket = new FireworkRocketEntity(entity.level(), entity.getX(), entity.getY(), entity.getZ(), fireworkStack);
                entity.level().addFreshEntity((Entity)rocket);
            }
            return true;
        }
        return shouldKill;
    }

    private ItemStack generateFirework(int color) {
        ItemStack stack = new ItemStack((ItemLike)Items.FIREWORK_ROCKET);
        CompoundTag explosion = new CompoundTag();
        explosion.putIntArray("Colors", new int[]{color});
        int type = 1;
        double rand = Math.random();
        if (rand > 0.25) {
            type = rand > 0.9 ? 2 : 0;
        }
        explosion.putInt("Type", type);
        if (Math.random() < 0.05) {
            if (Math.random() < 0.5) {
                explosion.putBoolean("Flicker", true);
            } else {
                explosion.putBoolean("Trail", true);
            }
        }
        ItemNBTHelper.setCompound(stack, "Explosion", explosion);
        CompoundTag fireworks = new CompoundTag();
        fireworks.putInt("Flight", (int)(Math.random() * 3.0 + 2.0));
        ListTag explosions = new ListTag();
        explosions.add((Object)explosion);
        fireworks.put("Explosions", (Tag)explosions);
        ItemNBTHelper.setCompound(stack, "Fireworks", fireworks);
        return stack;
    }
}

