/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.armor.terrasteel;

import com.google.common.base.Suppliers;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.equipment.armor.manasteel.ManasteelArmorItem;

public class TerrasteelArmorItem
extends ManasteelArmorItem {
    private static final Supplier<ItemStack[]> armorSet = Suppliers.memoize(() -> new ItemStack[]{new ItemStack((ItemLike)BotaniaItems.terrasteelHelm), new ItemStack((ItemLike)BotaniaItems.terrasteelChest), new ItemStack((ItemLike)BotaniaItems.terrasteelLegs), new ItemStack((ItemLike)BotaniaItems.terrasteelBoots)});

    public TerrasteelArmorItem(ArmorItem.Type type, Item.Properties props) {
        super(type, BotaniaAPI.instance().getTerrasteelArmorMaterial(), props);
    }

    @Override
    public String getArmorTextureAfterInk(ItemStack stack, EquipmentSlot slot) {
        return "botania:textures/model/armor_terrasteel.png";
    }

    @NotNull
    public Multimap<Attribute, AttributeModifier> getDefaultAttributeModifiers(@NotNull EquipmentSlot slot) {
        Multimap ret = super.getDefaultAttributeModifiers(slot);
        if (slot == this.getType().getSlot()) {
            UUID uuid = new UUID(BuiltInRegistries.ITEM.getKey((Object)this).hashCode() + slot.toString().hashCode(), 0L);
            ret = HashMultimap.create((Multimap)ret);
            int reduction = this.getMaterial().getDefenseForType(this.getType());
            ret.put((Object)Attributes.KNOCKBACK_RESISTANCE, (Object)new AttributeModifier(uuid, "Terrasteel modifier " + this.type, (double)reduction / 20.0, AttributeModifier.Operation.ADDITION));
        }
        return ret;
    }

    @Override
    public ItemStack[] getArmorSetStacks() {
        return armorSet.get();
    }

    @Override
    public boolean hasArmorSetItem(Player player, EquipmentSlot slot) {
        if (player == null) {
            return false;
        }
        ItemStack stack = player.getItemBySlot(slot);
        if (stack.isEmpty()) {
            return false;
        }
        return switch (slot) {
            case EquipmentSlot.HEAD -> stack.is(BotaniaItems.terrasteelHelm);
            case EquipmentSlot.CHEST -> stack.is(BotaniaItems.terrasteelChest);
            case EquipmentSlot.LEGS -> stack.is(BotaniaItems.terrasteelLegs);
            case EquipmentSlot.FEET -> stack.is(BotaniaItems.terrasteelBoots);
            default -> false;
        };
    }

    @Override
    public MutableComponent getArmorSetName() {
        return Component.translatable((String)"botania.armorset.terrasteel.name");
    }

    @Override
    public void addArmorSetDescription(ItemStack stack, List<Component> list) {
        list.add((Component)Component.translatable((String)"botania.armorset.terrasteel.desc0").withStyle(ChatFormatting.GRAY));
        list.add((Component)Component.translatable((String)"botania.armorset.terrasteel.desc1").withStyle(ChatFormatting.GRAY));
        list.add((Component)Component.translatable((String)"botania.armorset.terrasteel.desc2").withStyle(ChatFormatting.GRAY));
    }

    public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
        return true;
    }
}

