/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class RecipeUtils {
    public static boolean matches(List<Ingredient> inputs, Container inv, @Nullable IntSet usedSlots) {
        ItemStack input;
        ArrayList<Ingredient> ingredientsMissing = new ArrayList<Ingredient>(inputs);
        for (int i = 0; i < inv.getContainerSize() && !(input = inv.getItem(i)).isEmpty(); ++i) {
            int stackIndex = -1;
            for (int j = 0; j < ingredientsMissing.size(); ++j) {
                Ingredient ingr = (Ingredient)ingredientsMissing.get(j);
                if (!ingr.test(input)) continue;
                stackIndex = j;
                if (usedSlots == null) break;
                usedSlots.add(i);
                break;
            }
            if (stackIndex == -1) {
                return false;
            }
            ingredientsMissing.remove(stackIndex);
        }
        return ingredientsMissing.isEmpty();
    }

    public static NonNullList<ItemStack> getRemainingItemsSub(Container inv, Function<ItemStack, ItemStack> specialHandler) {
        NonNullList ret = NonNullList.withSize((int)inv.getContainerSize(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < ret.size(); ++i) {
            ItemStack item = inv.getItem(i);
            ItemStack special = specialHandler.apply(item);
            if (special != null) {
                ret.set(i, (Object)special);
                continue;
            }
            if (!item.getItem().hasCraftingRemainingItem()) continue;
            ret.set(i, (Object)new ItemStack((ItemLike)item.getItem().getCraftingRemainingItem()));
        }
        return ret;
    }
}

