/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.flower.functional;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.helper.MathHelper;

public class VinculotusBlockEntity
extends FunctionalFlowerBlockEntity {
    public static final Set<VinculotusBlockEntity> existingFlowers = Collections.newSetFromMap(new WeakHashMap());
    private static final int RANGE = 64;

    public VinculotusBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaFlowerBlocks.VINCULOTUS, pos, state);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (!this.getLevel().isClientSide) {
            existingFlowers.add(this);
        }
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Circle(this.getEffectivePos(), 64.0);
    }

    @Override
    public boolean acceptsRedstone() {
        return true;
    }

    @Override
    public int getColor() {
        return 680017;
    }

    @Override
    public int getMaxMana() {
        return 500;
    }

    @Nullable
    public static Vec3 onEndermanTeleport(EnderMan entity, double targetX, double targetY, double targetZ) {
        int cost = 50;
        ArrayList<VinculotusBlockEntity> possibleFlowers = new ArrayList<VinculotusBlockEntity>();
        for (VinculotusBlockEntity flower : existingFlowers) {
            double z;
            double y;
            double x;
            BlockPos activePos = flower.getEffectivePos();
            if (flower.redstoneSignal > 0 || flower.getMana() <= cost || flower.getLevel() != entity.level() || flower.getLevel().getBlockEntity(flower.getBlockPos()) != flower || !(MathHelper.pointDistanceSpace(x = (double)activePos.getX() + 0.5, y = (double)activePos.getY() + 1.5, z = (double)activePos.getZ() + 0.5, targetX, targetY, targetZ) < 64.0f)) continue;
            possibleFlowers.add(flower);
        }
        if (!possibleFlowers.isEmpty()) {
            VinculotusBlockEntity flower = (VinculotusBlockEntity)possibleFlowers.get(entity.level().random.nextInt(possibleFlowers.size()));
            BlockPos activePos = flower.getEffectivePos();
            double x = (double)activePos.getX() + 0.5;
            double y = (double)activePos.getY() + 1.5;
            double z = (double)activePos.getZ() + 0.5;
            flower.addMana(-cost);
            flower.sync();
            return new Vec3(x + Math.random() * 3.0 - 1.0, y, z + Math.random() * 3.0 - 1.0);
        }
        return null;
    }
}

