/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.flower.functional;

import net.minecraft.core.BlockPos;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.xplat.BotaniaConfig;

public class JadedAmaranthusBlockEntity
extends FunctionalFlowerBlockEntity {
    private static final int COST = 100;
    final int RANGE = 4;

    public JadedAmaranthusBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaFlowerBlocks.JADED_AMARANTHUS, pos, state);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (this.getLevel().isClientSide || this.redstoneSignal > 0) {
            return;
        }
        if (this.ticksExisted % 30 == 0 && this.getMana() >= 100) {
            BlockPos pos = new BlockPos(this.getEffectivePos().getX() - 4 + this.getLevel().random.nextInt(9), this.getEffectivePos().getY() + 4, this.getEffectivePos().getZ() - 4 + this.getLevel().random.nextInt(9));
            BlockPos up = pos.above();
            for (int i = 0; i < 8; ++i) {
                DyeColor color = DyeColor.byId((int)this.getLevel().random.nextInt(16));
                BlockState flower = BotaniaBlocks.getFlower(color).defaultBlockState();
                if (this.getLevel().isEmptyBlock(up) && flower.canSurvive((LevelReader)this.getLevel(), up)) {
                    if (BotaniaConfig.common().blockBreakParticles()) {
                        this.getLevel().levelEvent(2001, up, Block.getId((BlockState)flower));
                    }
                    this.getLevel().setBlockAndUpdate(up, flower);
                    this.getLevel().gameEvent(null, GameEvent.BLOCK_PLACE, up);
                    this.addMana(-100);
                    this.sync();
                    break;
                }
                up = pos;
                pos = pos.below();
            }
        }
    }

    @Override
    public boolean acceptsRedstone() {
        return true;
    }

    @Override
    public int getColor() {
        return 9835139;
    }

    @Override
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square(this.getEffectivePos(), 4);
    }

    @Override
    public int getMaxMana() {
        return 100;
    }
}

