/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.entity.PixieEntity;

public class PixieModel
extends EntityModel<PixieEntity> {
    private final ModelPart body;
    private final ModelPart leftWingT;
    private final ModelPart leftWingB;
    private final ModelPart rightWingT;
    private final ModelPart rightWingB;
    private static boolean evil = false;

    private static RenderType pixieLayer(ResourceLocation texture) {
        return evil ? RenderHelper.getDopplegangerLayer(texture) : RenderType.entityCutoutNoCull((ResourceLocation)texture);
    }

    public PixieModel(ModelPart root) {
        super(PixieModel::pixieLayer);
        this.body = root.getChild("body");
        this.leftWingT = root.getChild("leftWingT");
        this.leftWingB = root.getChild("leftWingB");
        this.rightWingT = root.getChild("rightWingT");
        this.rightWingB = root.getChild("rightWingB");
    }

    public static MeshDefinition createMesh() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        root.addOrReplaceChild("body", CubeListBuilder.create().addBox(-2.5f, 0.0f, -2.5f, 5.0f, 5.0f, 5.0f), PartPose.offset((float)0.0f, (float)16.0f, (float)0.0f));
        root.addOrReplaceChild("leftWingT", CubeListBuilder.create().texOffs(0, 4).addBox(0.0f, -5.0f, 0.0f, 0.0f, 5.0f, 6.0f), PartPose.offsetAndRotation((float)2.5f, (float)18.0f, (float)0.5f, (float)0.2618f, (float)0.5236f, (float)0.2618f));
        root.addOrReplaceChild("leftWingB", CubeListBuilder.create().texOffs(0, 11).addBox(0.0f, 0.0f, 0.0f, 0.0f, 3.0f, 4.0f), PartPose.offsetAndRotation((float)2.5f, (float)18.0f, (float)0.5f, (float)-0.2618f, (float)0.2618f, (float)-0.2618f));
        root.addOrReplaceChild("rightWingT", CubeListBuilder.create().texOffs(0, 4).addBox(0.0f, -5.0f, 0.0f, 0.0f, 5.0f, 6.0f), PartPose.offsetAndRotation((float)-2.5f, (float)18.0f, (float)0.5f, (float)0.2618f, (float)-0.5236f, (float)-0.2618f));
        root.addOrReplaceChild("rightWingB", CubeListBuilder.create().texOffs(0, 11).addBox(0.0f, 0.0f, 0.0f, 0.0f, 3.0f, 4.0f), PartPose.offsetAndRotation((float)-2.5f, (float)18.0f, (float)0.5f, (float)-0.2618f, (float)-0.2618f, (float)0.2618f));
        return mesh;
    }

    public void renderToBuffer(PoseStack ms, VertexConsumer buffer, int light, int overlay, float red, float green, float blue, float alpha) {
        this.body.render(ms, buffer, light, overlay);
        this.leftWingT.render(ms, buffer, light, overlay);
        this.leftWingB.render(ms, buffer, light, overlay);
        this.rightWingT.render(ms, buffer, light, overlay);
        this.rightWingB.render(ms, buffer, light, overlay);
    }

    public void setupAnim(PixieEntity entity, float f, float f1, float f2, float f3, float f4) {
        evil = entity.getPixieType() == 1;
        this.rightWingT.yRot = -(Mth.cos((float)(f2 * 1.7f)) * (float)Math.PI * 0.5f);
        this.leftWingT.yRot = Mth.cos((float)(f2 * 1.7f)) * (float)Math.PI * 0.5f;
        this.rightWingB.yRot = -(Mth.cos((float)(f2 * 1.7f)) * (float)Math.PI * 0.25f);
        this.leftWingB.yRot = Mth.cos((float)(f2 * 1.7f)) * (float)Math.PI * 0.25f;
    }
}

