/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.gui.box;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.client.gui.SlotLocked;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.BaubleBoxItem;
import vazkii.botania.common.item.BotaniaItems;

public class BaubleBoxContainer
extends AbstractContainerMenu {
    private final ItemStack box;

    public static BaubleBoxContainer fromNetwork(int windowId, Inventory inv, FriendlyByteBuf buf) {
        InteractionHand hand = buf.readBoolean() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        return new BaubleBoxContainer(windowId, inv, inv.player.getItemInHand(hand));
    }

    public BaubleBoxContainer(int windowId, Inventory playerInv, ItemStack box) {
        super(BotaniaItems.BAUBLE_BOX_CONTAINER, windowId);
        int j;
        int i;
        this.box = box;
        SimpleContainer baubleBoxInv = !playerInv.player.level().isClientSide ? BaubleBoxItem.getInventory(box) : new SimpleContainer(24);
        for (i = 0; i < 4; ++i) {
            for (j = 0; j < 6; ++j) {
                int k = j + i * 6;
                this.addSlot(new Slot((Container)baubleBoxInv, k, 62 + j * 18, 8 + i * 18){

                    public boolean mayPlace(@NotNull ItemStack stack) {
                        return EquipmentHandler.instance.isAccessory(stack);
                    }
                });
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInv, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            if (playerInv.getItem(i) == box) {
                this.addSlot(new SlotLocked((Container)playerInv, i, 8 + i * 18, 142));
                continue;
            }
            this.addSlot(new Slot((Container)playerInv, i, 8 + i * 18, 142));
        }
    }

    public boolean stillValid(@NotNull Player player) {
        ItemStack main = player.getMainHandItem();
        ItemStack off = player.getOffhandItem();
        return !main.isEmpty() && main == this.box || !off.isEmpty() && off == this.box;
    }

    @NotNull
    public ItemStack quickMoveStack(Player player, int slotIndex) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotIndex);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            int boxStart = 0;
            int boxEnd = boxStart + 24;
            int invEnd = boxEnd + 36;
            if (slotIndex < boxEnd ? !this.moveItemStackTo(itemstack1, boxEnd, invEnd, true) : !itemstack1.isEmpty() && EquipmentHandler.instance.isAccessory(itemstack1) && !this.moveItemStackTo(itemstack1, boxStart, boxEnd, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemstack1);
        }
        return itemstack;
    }

    public void removed(@NotNull Player player) {
        if (!player.level().isClientSide) {
            ItemNBTHelper.setBoolean(this.box, "open", false);
        }
        super.removed(player);
    }
}

