/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.handler;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import vazkii.botania.api.mana.ManaCollector;
import vazkii.botania.client.gui.ItemsRemainingRenderHandler;
import vazkii.botania.client.render.block_entity.RedStringBlockEntityRenderer;
import vazkii.botania.common.block.flower.functional.VinculotusBlockEntity;
import vazkii.botania.common.handler.ManaNetworkHandler;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.item.LexicaBotaniaItem;
import vazkii.botania.common.item.WandOfTheForestItem;

public final class ClientTickHandler {
    public static int ticksWithLexicaOpen = 0;
    public static int pageFlipTicks = 0;
    public static int ticksInGame = 0;
    public static float partialTicks = 0.0f;

    private ClientTickHandler() {
    }

    public static float total() {
        return (float)ticksInGame + partialTicks;
    }

    public static void renderTick(float renderTickTime) {
        partialTicks = renderTickTime;
    }

    public static void clientTickEnd(Minecraft mc) {
        RedStringBlockEntityRenderer.tick();
        ItemsRemainingRenderHandler.tick();
        if (mc.level == null) {
            ManaNetworkHandler.instance.clear();
            VinculotusBlockEntity.existingFlowers.clear();
        }
        if (!mc.isPaused()) {
            ++ticksInGame;
            partialTicks = 0.0f;
            LocalPlayer player = mc.player;
            if (player != null && PlayerHelper.hasHeldItemClass((Player)player, WandOfTheForestItem.class)) {
                for (ManaCollector collector : ImmutableList.copyOf(ManaNetworkHandler.instance.getAllCollectorsInWorld((Level)Minecraft.getInstance().level))) {
                    collector.onClientDisplayTick();
                }
            }
        }
        int ticksToOpen = 10;
        if (LexicaBotaniaItem.isOpen()) {
            if (ticksWithLexicaOpen < 0) {
                ticksWithLexicaOpen = 0;
            }
            if (ticksWithLexicaOpen < ticksToOpen) {
                ++ticksWithLexicaOpen;
            }
            if (pageFlipTicks > 0) {
                --pageFlipTicks;
            }
        } else {
            pageFlipTicks = 0;
            if (ticksWithLexicaOpen > 0) {
                if (ticksWithLexicaOpen > ticksToOpen) {
                    ticksWithLexicaOpen = ticksToOpen;
                }
                --ticksWithLexicaOpen;
            }
        }
    }

    public static void notifyPageChange() {
        if (pageFlipTicks == 0) {
            pageFlipTicks = 5;
        }
    }
}

