/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.function.Consumer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.data.recipes.BotaniaRecipeProvider;
import vazkii.botania.data.recipes.GogAlternationResult;
import vazkii.botania.data.recipes.NbtOutputResult;

public class PetalApothecaryProvider
extends BotaniaRecipeProvider {
    private static final Ingredient DEFAULT_REAGENT = Ingredient.of(BotaniaTags.Items.SEED_APOTHECARY_REAGENT);

    public PetalApothecaryProvider(PackOutput packOutput) {
        super(packOutput);
    }

    public String getName() {
        return "Botania petal apothecary recipes";
    }

    @Override
    public void buildRecipes(Consumer<net.minecraft.data.recipes.FinishedRecipe> consumer) {
        Ingredient white = PetalApothecaryProvider.tagIngr("petals/white");
        Ingredient orange = PetalApothecaryProvider.tagIngr("petals/orange");
        Ingredient magenta = PetalApothecaryProvider.tagIngr("petals/magenta");
        Ingredient lightBlue = PetalApothecaryProvider.tagIngr("petals/light_blue");
        Ingredient yellow = PetalApothecaryProvider.tagIngr("petals/yellow");
        Ingredient lime = PetalApothecaryProvider.tagIngr("petals/lime");
        Ingredient pink = PetalApothecaryProvider.tagIngr("petals/pink");
        Ingredient gray = PetalApothecaryProvider.tagIngr("petals/gray");
        Ingredient lightGray = PetalApothecaryProvider.tagIngr("petals/light_gray");
        Ingredient cyan = PetalApothecaryProvider.tagIngr("petals/cyan");
        Ingredient purple = PetalApothecaryProvider.tagIngr("petals/purple");
        Ingredient blue = PetalApothecaryProvider.tagIngr("petals/blue");
        Ingredient brown = PetalApothecaryProvider.tagIngr("petals/brown");
        Ingredient green = PetalApothecaryProvider.tagIngr("petals/green");
        Ingredient red = PetalApothecaryProvider.tagIngr("petals/red");
        Ingredient black = PetalApothecaryProvider.tagIngr("petals/black");
        Ingredient runeWater = Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.runeWater});
        Ingredient runeFire = Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.runeFire});
        Ingredient runeEarth = Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.runeEarth});
        Ingredient runeAir = Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.runeAir});
        Ingredient runeSpring = Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.runeSpring});
        Ingredient runeSummer = Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.runeSummer});
        Ingredient runeAutumn = Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.runeAutumn});
        Ingredient runeWinter = Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.runeWinter});
        Ingredient runeMana = Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.runeMana});
        Ingredient runeLust = Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.runeLust});
        Ingredient runeGluttony = Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.runeGluttony});
        Ingredient runeGreed = Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.runeGreed});
        Ingredient runeSloth = Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.runeSloth});
        Ingredient runeWrath = Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.runeWrath});
        Ingredient runeEnvy = Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.runeEnvy});
        Ingredient runePride = Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.runePride});
        Ingredient redstoneRoot = Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.redstoneRoot});
        Ingredient pixieDust = Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.pixieDust});
        Ingredient gaiaSpirit = Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.lifeEssence});
        consumer.accept(PetalApothecaryProvider.make((ItemLike)BotaniaFlowerBlocks.pureDaisy, white, white, white, white));
        consumer.accept(PetalApothecaryProvider.make((ItemLike)BotaniaFlowerBlocks.manastar, lightBlue, green, red, cyan));
        consumer.accept(PetalApothecaryProvider.make((ItemLike)BotaniaFlowerBlocks.endoflame, brown, brown, red, lightGray));
        consumer.accept(PetalApothecaryProvider.make((ItemLike)BotaniaFlowerBlocks.hydroangeas, blue, blue, cyan, cyan));
        consumer.accept(PetalApothecaryProvider.make((ItemLike)BotaniaFlowerBlocks.thermalily, red, orange, orange, runeEarth, runeFire));
        consumer.accept(PetalApothecaryProvider.make((ItemLike)BotaniaFlowerBlocks.rosaArcana, pink, pink, purple, purple, lime, runeMana));
        consumer.accept(PetalApothecaryProvider.make((ItemLike)BotaniaFlowerBlocks.munchdew, lime, lime, red, red, green, runeGluttony));
        consumer.accept(PetalApothecaryProvider.make((ItemLike)BotaniaFlowerBlocks.entropinnyum, red, red, gray, gray, white, white, runeWrath, runeFire));
        consumer.accept(PetalApothecaryProvider.make((ItemLike)BotaniaFlowerBlocks.kekimurus, white, white, orange, orange, brown, brown, runeGluttony, pixieDust));
        consumer.accept(PetalApothecaryProvider.make((ItemLike)BotaniaFlowerBlocks.gourmaryllis, lightGray, lightGray, yellow, yellow, red, runeFire, runeSummer));
        consumer.accept(PetalApothecaryProvider.make((ItemLike)BotaniaFlowerBlocks.narslimmus, lime, lime, green, green, black, runeSummer, runeWater));
        consumer.accept(PetalApothecaryProvider.make((ItemLike)BotaniaFlowerBlocks.spectrolus, red, red, green, green, blue, blue, white, white, runeWinter, runeAir, pixieDust));
        consumer.accept(PetalApothecaryProvider.make((ItemLike)BotaniaFlowerBlocks.rafflowsia, purple, purple, green, green, black, runeEarth, runePride, pixieDust));
        consumer.accept(PetalApothecaryProvider.make((ItemLike)BotaniaFlowerBlocks.shulkMeNot, purple, purple, magenta, magenta, lightGray, gaiaSpirit, runeEnvy, runeWrath));
        consumer.accept(PetalApothecaryProvider.make((ItemLike)BotaniaFlowerBlocks.dandelifeon, purple, purple, lime, green, runeWater, runeFire, runeEarth, runeAir, redstoneRoot, gaiaSpirit));
        consumer.accept(PetalApothecaryProvider.make((ItemLike)BotaniaFlowerBlocks.jadedAmaranthus, purple, lime, green, runeSpring, redstoneRoot));
        consumer.accept(PetalApothecaryProvider.make((ItemLike)BotaniaFlowerBlocks.bellethorn, red, red, red, cyan, cyan, redstoneRoot));
        consumer.accept(PetalApothecaryProvider.make((ItemLike)BotaniaFlowerBlocks.dreadthorn, black, black, black, cyan, cyan, redstoneRoot));
        consumer.accept(PetalApothecaryProvider.make((ItemLike)BotaniaFlowerBlocks.heiseiDream, magenta, magenta, purple, pink, runeWrath, pixieDust));
        consumer.accept(PetalApothecaryProvider.make((ItemLike)BotaniaFlowerBlocks.tigerseye, yellow, brown, orange, lime, runeAutumn));
        FinishedRecipe base = PetalApothecaryProvider.make((ItemLike)BotaniaFlowerBlocks.orechid, gray, gray, yellow, green, red, runePride, runeGreed, redstoneRoot, pixieDust);
        FinishedRecipe gog = PetalApothecaryProvider.make((ItemLike)BotaniaFlowerBlocks.orechid, gray, gray, yellow, yellow, green, green, red, red);
        consumer.accept(new GogAlternationResult(gog, base));
        consumer.accept(PetalApothecaryProvider.make((ItemLike)BotaniaFlowerBlocks.orechidIgnem, red, red, white, white, pink, runePride, runeGreed, redstoneRoot, pixieDust));
        consumer.accept(PetalApothecaryProvider.make((ItemLike)BotaniaFlowerBlocks.fallenKanade, white, white, yellow, yellow, orange, runeSpring));
        consumer.accept(PetalApothecaryProvider.make((ItemLike)BotaniaFlowerBlocks.exoflame, red, red, gray, lightGray, runeFire, runeSummer));
        consumer.accept(PetalApothecaryProvider.make((ItemLike)BotaniaFlowerBlocks.agricarnation, lime, lime, green, yellow, runeSpring, redstoneRoot));
        consumer.accept(PetalApothecaryProvider.make((ItemLike)BotaniaFlowerBlocks.hopperhock, gray, gray, lightGray, lightGray, runeAir, redstoneRoot));
        consumer.accept(PetalApothecaryProvider.make((ItemLike)BotaniaFlowerBlocks.tangleberrie, cyan, cyan, gray, lightGray, runeAir, runeEarth));
        consumer.accept(PetalApothecaryProvider.make((ItemLike)BotaniaFlowerBlocks.jiyuulia, pink, pink, purple, lightGray, runeWater, runeAir));
        consumer.accept(PetalApothecaryProvider.make((ItemLike)BotaniaFlowerBlocks.rannuncarpus, orange, orange, yellow, runeEarth, redstoneRoot));
        consumer.accept(PetalApothecaryProvider.make((ItemLike)BotaniaFlowerBlocks.hyacidus, purple, purple, magenta, magenta, green, runeWater, runeAutumn, redstoneRoot));
        consumer.accept(PetalApothecaryProvider.make((ItemLike)BotaniaFlowerBlocks.pollidisiac, red, red, pink, pink, orange, runeLust, runeFire));
        consumer.accept(PetalApothecaryProvider.make((ItemLike)BotaniaFlowerBlocks.clayconia, lightGray, lightGray, gray, cyan, runeEarth));
        consumer.accept(PetalApothecaryProvider.make((ItemLike)BotaniaFlowerBlocks.loonium, green, green, green, green, gray, runeSloth, runeGluttony, runeEnvy, redstoneRoot, pixieDust));
        consumer.accept(PetalApothecaryProvider.make((ItemLike)BotaniaFlowerBlocks.daffomill, white, white, brown, yellow, runeAir, redstoneRoot));
        consumer.accept(PetalApothecaryProvider.make((ItemLike)BotaniaFlowerBlocks.vinculotus, black, black, purple, purple, green, runeWater, runeSloth, runeLust, redstoneRoot));
        consumer.accept(PetalApothecaryProvider.make((ItemLike)BotaniaFlowerBlocks.spectranthemum, white, white, lightGray, lightGray, cyan, runeEnvy, runeWater, redstoneRoot, pixieDust));
        consumer.accept(PetalApothecaryProvider.make((ItemLike)BotaniaFlowerBlocks.medumone, brown, brown, gray, gray, runeEarth, redstoneRoot));
        consumer.accept(PetalApothecaryProvider.make((ItemLike)BotaniaFlowerBlocks.marimorphosis, gray, yellow, green, red, runeEarth, runeFire, redstoneRoot));
        consumer.accept(PetalApothecaryProvider.make((ItemLike)BotaniaFlowerBlocks.bubbell, cyan, cyan, lightBlue, lightBlue, blue, blue, runeWater, runeSummer, pixieDust));
        consumer.accept(PetalApothecaryProvider.make((ItemLike)BotaniaFlowerBlocks.solegnolia, brown, brown, red, blue, redstoneRoot));
        consumer.accept(PetalApothecaryProvider.make((ItemLike)BotaniaFlowerBlocks.bergamute, orange, green, green, redstoneRoot));
        consumer.accept(PetalApothecaryProvider.make((ItemLike)BotaniaFlowerBlocks.labellia, yellow, yellow, blue, white, black, runeAutumn, redstoneRoot, pixieDust));
        consumer.accept(PetalApothecaryProvider.make((ItemLike)BotaniaBlocks.motifDaybloom, yellow, yellow, orange, lightBlue));
        consumer.accept(PetalApothecaryProvider.make((ItemLike)BotaniaBlocks.motifNightshade, black, black, purple, gray));
        ItemStack stack = new ItemStack((ItemLike)Items.PLAYER_HEAD);
        ItemNBTHelper.setString(stack, "SkullOwner", "Vazkii");
        Object[] inputs = new Ingredient[16];
        Arrays.fill(inputs, pink);
        consumer.accept(new NbtOutputResult(new FinishedRecipe(PetalApothecaryProvider.idFor(ResourceLocationHelper.prefix("vazkii_head")), stack, DEFAULT_REAGENT, (Ingredient[])inputs), stack.getTag()));
    }

    protected static Ingredient tagIngr(String tag) {
        return Ingredient.of((TagKey)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocationHelper.prefix(tag)));
    }

    protected static FinishedRecipe make(ItemLike item, Ingredient ... ingredients) {
        return new FinishedRecipe(PetalApothecaryProvider.idFor(BuiltInRegistries.ITEM.getKey((Object)item.asItem())), new ItemStack(item), DEFAULT_REAGENT, ingredients);
    }

    protected static ResourceLocation idFor(ResourceLocation name) {
        return new ResourceLocation(name.getNamespace(), "petal_apothecary/" + name.getPath());
    }

    protected static class FinishedRecipe
    implements net.minecraft.data.recipes.FinishedRecipe {
        private final ResourceLocation id;
        private final ItemStack output;
        private final Ingredient reagent;
        private final Ingredient[] inputs;

        private FinishedRecipe(ResourceLocation id, ItemStack output, Ingredient reagent, Ingredient ... inputs) {
            this.id = id;
            this.output = output;
            this.reagent = reagent;
            this.inputs = inputs;
        }

        public void serializeRecipeData(JsonObject json) {
            json.add("output", (JsonElement)ItemNBTHelper.serializeStack(this.output));
            JsonArray ingredients = new JsonArray();
            for (Ingredient ingr : this.inputs) {
                ingredients.add(ingr.toJson());
            }
            json.add("reagent", this.reagent.toJson());
            json.add("ingredients", (JsonElement)ingredients);
        }

        public ResourceLocation getId() {
            return this.id;
        }

        public RecipeSerializer<?> getType() {
            return BotaniaRecipeTypes.PETAL_SERIALIZER;
        }

        @Nullable
        public JsonObject serializeAdvancement() {
            return null;
        }

        @Nullable
        public ResourceLocation getAdvancementId() {
            return null;
        }
    }
}

