/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.armor.manaweave;

import com.google.common.base.Suppliers;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.client.core.proxy.ClientProxy;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.equipment.armor.manasteel.ManasteelArmorItem;
import vazkii.botania.xplat.XplatAbstractions;

public class ManaweaveArmorItem
extends ManasteelArmorItem {
    private static final Supplier<ItemStack[]> armorSet = Suppliers.memoize(() -> new ItemStack[]{new ItemStack((ItemLike)BotaniaItems.manaweaveHelm), new ItemStack((ItemLike)BotaniaItems.manaweaveChest), new ItemStack((ItemLike)BotaniaItems.manaweaveLegs), new ItemStack((ItemLike)BotaniaItems.manaweaveBoots)});

    public ManaweaveArmorItem(ArmorItem.Type type, Item.Properties props) {
        super(type, BotaniaAPI.instance().getManaweaveArmorMaterial(), props);
    }

    @Override
    public String getArmorTextureAfterInk(ItemStack stack, EquipmentSlot slot) {
        return ClientProxy.jingleTheBells ? "botania:textures/model/armor_manaweave_holiday.png" : "botania:textures/model/armor_manaweave.png";
    }

    @NotNull
    public String getDescriptionId(ItemStack stack) {
        String name = super.getDescriptionId(stack);
        if (XplatAbstractions.INSTANCE.isPhysicalClient() && ClientProxy.jingleTheBells) {
            name = name.replaceAll("manaweave", "santaweave");
        }
        return name;
    }

    @Override
    public ItemStack[] getArmorSetStacks() {
        return armorSet.get();
    }

    @Override
    public boolean hasArmorSetItem(Player player, EquipmentSlot slot) {
        if (player == null) {
            return false;
        }
        ItemStack stack = player.getItemBySlot(slot);
        if (stack.isEmpty()) {
            return false;
        }
        return switch (slot) {
            case EquipmentSlot.HEAD -> stack.is(BotaniaItems.manaweaveHelm);
            case EquipmentSlot.CHEST -> stack.is(BotaniaItems.manaweaveChest);
            case EquipmentSlot.LEGS -> stack.is(BotaniaItems.manaweaveLegs);
            case EquipmentSlot.FEET -> stack.is(BotaniaItems.manaweaveBoots);
            default -> false;
        };
    }

    @Override
    public MutableComponent getArmorSetName() {
        return Component.translatable((String)"botania.armorset.manaweave.name");
    }

    @Override
    public void addInformationAfterShift(ItemStack stack, Level world, List<Component> list, TooltipFlag flags) {
        if (XplatAbstractions.INSTANCE.isPhysicalClient() && ClientProxy.jingleTheBells) {
            list.add((Component)Component.translatable((String)"botaniamisc.santaweaveInfo"));
            list.add((Component)Component.literal((String)""));
        }
        super.addInformationAfterShift(stack, world, list, flags);
    }

    @Override
    public void addArmorSetDescription(ItemStack stack, List<Component> list) {
        list.add((Component)Component.translatable((String)"botania.armorset.manaweave.desc0").withStyle(ChatFormatting.GRAY));
        list.add((Component)Component.translatable((String)"botania.armorset.manaweave.desc1").withStyle(ChatFormatting.GRAY));
    }

    public boolean canWalkOnPowderedSnow(ItemStack stack, LivingEntity wearer) {
        return stack.is(BotaniaItems.manaweaveBoots);
    }
}

