/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.internal_caps;

import net.minecraft.nbt.CompoundTag;
import vazkii.botania.common.internal_caps.SerializableComponent;

public class ItemFlagsComponent
extends SerializableComponent {
    public boolean elvenPortalSpawned = false;
    public boolean apothecarySpawned = false;
    public boolean manaInfusionSpawned = false;
    public boolean runicAltarSpawned = false;
    public int timeCounter = 0;
    private static final String TAG_PORTAL_SPAWNED = "ElvenPortalSpawned";
    private static final String TAG_APOTHECARY_SPAWNED = "ApothecarySpawned";
    private static final String TAG_INFUSION_SPAWNED = "ManaInfusionSpawned";
    private static final String TAG_ALTAR_SPAWNED = "RunicAltarSpawned";
    private static final String TAG_TIME_COUNTER = "timeCounter";

    @Override
    public void readFromNbt(CompoundTag tag) {
        this.elvenPortalSpawned = tag.getBoolean(TAG_PORTAL_SPAWNED);
        this.apothecarySpawned = tag.getBoolean(TAG_APOTHECARY_SPAWNED);
        this.manaInfusionSpawned = tag.getBoolean(TAG_INFUSION_SPAWNED);
        this.runicAltarSpawned = tag.getBoolean(TAG_ALTAR_SPAWNED);
        this.timeCounter = tag.getInt(TAG_TIME_COUNTER);
        if (tag.getBoolean("_elvenPortal")) {
            this.elvenPortalSpawned = true;
        }
        if (tag.getInt("manaInfusionCooldown") > 0) {
            this.manaInfusionSpawned = true;
        }
        if (tag.getInt("runicAltarCooldown") > 0) {
            this.runicAltarSpawned = true;
        }
    }

    @Override
    public void writeToNbt(CompoundTag tag) {
        tag.putBoolean(TAG_PORTAL_SPAWNED, this.elvenPortalSpawned);
        tag.putBoolean(TAG_APOTHECARY_SPAWNED, this.apothecarySpawned);
        tag.putBoolean(TAG_INFUSION_SPAWNED, this.runicAltarSpawned);
        tag.putBoolean(TAG_ALTAR_SPAWNED, this.manaInfusionSpawned);
        tag.putInt(TAG_TIME_COUNTER, this.timeCounter);
    }

    public void tick() {
        ++this.timeCounter;
    }

    public boolean spawnedByInWorldRecipe() {
        return this.elvenPortalSpawned || this.apothecarySpawned || this.runicAltarSpawned || this.manaInfusionSpawned;
    }
}

