/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.helper;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.minecraft.advancements.Advancement;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public final class PlayerHelper {
    private static final Pattern FAKE_PLAYER_PATTERN = Pattern.compile("^(?:\\[.*]|ComputerCraft)$");
    private static Class<? extends Player> fakePlayerClass;

    public static void setFakePlayerClass(Class<? extends Player> fakePlayerClass) {
        PlayerHelper.fakePlayerClass = fakePlayerClass;
    }

    public static boolean isTruePlayer(@Nullable Entity e) {
        if (!(e instanceof Player)) {
            return false;
        }
        Player player = (Player)e;
        String name = player.getName().getString();
        return (fakePlayerClass == null || !fakePlayerClass.isInstance(player)) && !FAKE_PLAYER_PATTERN.matcher(name).matches();
    }

    public static List<Player> getRealPlayersIn(Level level, AABB aabb) {
        return level.getEntitiesOfClass(Player.class, aabb, player -> PlayerHelper.isTruePlayer((Entity)player) && !player.isSpectator());
    }

    public static boolean hasAnyHeldItem(Player player) {
        return !player.getMainHandItem().isEmpty() || !player.getOffhandItem().isEmpty();
    }

    public static boolean hasHeldItem(Player player, Item item) {
        return !player.getMainHandItem().isEmpty() && player.getMainHandItem().is(item) || !player.getOffhandItem().isEmpty() && player.getOffhandItem().is(item);
    }

    public static boolean hasHeldItemClass(Player player, Class<?> template) {
        return !player.getMainHandItem().isEmpty() && template.isAssignableFrom(player.getMainHandItem().getItem().getClass()) || !player.getOffhandItem().isEmpty() && template.isAssignableFrom(player.getOffhandItem().getItem().getClass());
    }

    public static ItemStack getFirstHeldItem(LivingEntity living, Item item) {
        return PlayerHelper.getFirstHeldItem(living, (ItemStack s) -> s.is(item));
    }

    public static ItemStack getFirstHeldItem(LivingEntity living, Predicate<ItemStack> pred) {
        ItemStack main = living.getMainHandItem();
        ItemStack offhand = living.getOffhandItem();
        if (!main.isEmpty() && pred.test(main)) {
            return main;
        }
        if (!offhand.isEmpty() && pred.test(offhand)) {
            return offhand;
        }
        return ItemStack.EMPTY;
    }

    public static ItemStack getFirstHeldItemClass(LivingEntity living, Class<?> template) {
        return PlayerHelper.getFirstHeldItem(living, (ItemStack s) -> template.isAssignableFrom(s.getItem().getClass()));
    }

    public static ItemStack getAmmo(Player player, Predicate<ItemStack> ammoFunc) {
        if (ammoFunc.test(player.getItemInHand(InteractionHand.OFF_HAND))) {
            return player.getItemInHand(InteractionHand.OFF_HAND);
        }
        if (ammoFunc.test(player.getItemInHand(InteractionHand.MAIN_HAND))) {
            return player.getItemInHand(InteractionHand.MAIN_HAND);
        }
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack itemstack = player.getInventory().getItem(i);
            if (!ammoFunc.test(itemstack)) continue;
            return itemstack;
        }
        return ItemStack.EMPTY;
    }

    public static boolean hasAmmo(Player player, Predicate<ItemStack> ammoFunc) {
        return !PlayerHelper.getAmmo(player, ammoFunc).isEmpty();
    }

    public static void consumeAmmo(Player player, Predicate<ItemStack> ammoFunc) {
        ItemStack ammo = PlayerHelper.getAmmo(player, ammoFunc);
        if (!ammo.isEmpty()) {
            ammo.shrink(1);
        }
    }

    public static ItemStack getItemFromInventory(Player player, Predicate<ItemStack> itemPred) {
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack item = player.getInventory().getItem(i);
            if (!itemPred.test(item)) continue;
            return item;
        }
        return ItemStack.EMPTY;
    }

    public static ItemStack getItemClassFromInventory(Player player, Class<?> template) {
        return PlayerHelper.getItemFromInventory(player, s -> template.isAssignableFrom(s.getItem().getClass()));
    }

    public static boolean hasAdvancement(ServerPlayer player, ResourceLocation advancementId) {
        PlayerAdvancements advancements = player.getAdvancements();
        ServerAdvancementManager manager = player.level().getServer().getAdvancements();
        Advancement advancement = manager.getAdvancement(advancementId);
        return advancement != null && advancements.getOrStartProgress(advancement).isDone();
    }

    public static void grantCriterion(ServerPlayer player, ResourceLocation advancementId, String criterion) {
        PlayerAdvancements advancements = player.getAdvancements();
        ServerAdvancementManager manager = player.level().getServer().getAdvancements();
        Advancement advancement = manager.getAdvancement(advancementId);
        if (advancement != null && !advancements.getOrStartProgress(advancement).isDone()) {
            advancements.award(advancement, criterion);
        }
    }

    public static InteractionResult substituteUse(UseOnContext ctx, ItemStack toUse) {
        return (InteractionResult)PlayerHelper.substituteUseTrackPos(ctx, toUse).getFirst();
    }

    public static Pair<InteractionResult, BlockPos> substituteUseTrackPos(UseOnContext ctx, ItemStack toUse) {
        ItemUseContextWithNullPlayer newCtx;
        ItemStack save = ItemStack.EMPTY;
        BlockHitResult hit = new BlockHitResult(ctx.getClickLocation(), ctx.getClickedFace(), ctx.getClickedPos(), ctx.isInside());
        if (ctx.getPlayer() != null) {
            save = ctx.getPlayer().getItemInHand(ctx.getHand());
            ctx.getPlayer().setItemInHand(ctx.getHand(), toUse);
            newCtx = new UseOnContext(ctx.getPlayer(), ctx.getHand(), hit);
        } else {
            newCtx = new ItemUseContextWithNullPlayer(ctx.getLevel(), ctx.getHand(), toUse, hit);
        }
        BlockPos finalPos = new BlockPlaceContext((UseOnContext)newCtx).getClickedPos();
        InteractionResult result = toUse.useOn((UseOnContext)newCtx);
        if (ctx.getPlayer() != null) {
            ctx.getPlayer().setItemInHand(ctx.getHand(), save);
        }
        return Pair.of((Object)result, (Object)finalPos);
    }

    private PlayerHelper() {
    }

    private static class ItemUseContextWithNullPlayer
    extends UseOnContext {
        public ItemUseContextWithNullPlayer(Level world, InteractionHand hand, ItemStack stack, BlockHitResult rayTraceResult) {
            super(world, null, hand, stack, rayTraceResult);
        }
    }
}

