/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundRemoveMobEffectPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.advancements.GaiaGuardianNoArmorTrigger;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.entity.BotaniaEntities;
import vazkii.botania.common.entity.MagicLandmineEntity;
import vazkii.botania.common.entity.MagicMissileEntity;
import vazkii.botania.common.entity.PixieEntity;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.MathHelper;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.common.proxy.Proxy;
import vazkii.botania.network.EffectType;
import vazkii.botania.network.clientbound.BotaniaEffectPacket;
import vazkii.botania.network.clientbound.SpawnGaiaGuardianPacket;
import vazkii.botania.xplat.XplatAbstractions;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.IStateMatcher;
import vazkii.patchouli.api.PatchouliAPI;

public class GaiaGuardianEntity
extends Mob {
    public static final float ARENA_RANGE = 12.0f;
    public static final int ARENA_HEIGHT = 5;
    private static final int SPAWN_TICKS = 160;
    public static final float MAX_HP = 320.0f;
    public static final Supplier<IMultiblock> ARENA_MULTIBLOCK = Suppliers.memoize(() -> {
        IStateMatcher beaconBase = PatchouliAPI.get().predicateMatcher(Blocks.IRON_BLOCK, state -> state.is(BlockTags.BEACON_BASE_BLOCKS));
        return PatchouliAPI.get().makeMultiblock((String[][])new String[][]{{"P_______P", "_________", "_________", "_________", "_________", "_________", "_________", "_________", "P_______P"}, {"_________", "_________", "_________", "_________", "____B____", "_________", "_________", "_________", "_________"}, {"_________", "_________", "_________", "___III___", "___I0I___", "___III___", "_________", "_________", "_________"}}, new Object[]{Character.valueOf('P'), BotaniaBlocks.gaiaPylon, Character.valueOf('B'), Blocks.BEACON, Character.valueOf('I'), beaconBase, Character.valueOf('0'), beaconBase});
    });
    private static final int MOB_SPAWN_START_TICKS = 20;
    private static final int MOB_SPAWN_END_TICKS = 80;
    private static final int MOB_SPAWN_BASE_TICKS = 800;
    private static final int MOB_SPAWN_TICKS = 900;
    private static final int MOB_SPAWN_WAVES = 10;
    private static final int MOB_SPAWN_WAVE_TIME = 80;
    private static final int DAMAGE_CAP = 32;
    private static final String TAG_INVUL_TIME = "invulTime";
    private static final String TAG_AGGRO = "aggro";
    private static final String TAG_SOURCE_X = "sourceX";
    private static final String TAG_SOURCE_Y = "sourceY";
    private static final String TAG_SOURCE_Z = "sourcesZ";
    private static final String TAG_MOB_SPAWN_TICKS = "mobSpawnTicks";
    private static final String TAG_HARD_MODE = "hardMode";
    private static final String TAG_PLAYER_COUNT = "playerCount";
    private static final TagKey<Block> BLACKLIST = BotaniaTags.Blocks.GAIA_BREAK_BLACKLIST;
    private static final EntityDataAccessor<Integer> INVUL_TIME = SynchedEntityData.defineId(GaiaGuardianEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final List<BlockPos> PYLON_LOCATIONS = ImmutableList.of((Object)new BlockPos(4, 1, 4), (Object)new BlockPos(4, 1, -4), (Object)new BlockPos(-4, 1, 4), (Object)new BlockPos(-4, 1, -4));
    private static final List<ResourceLocation> CHEATY_BLOCKS = Arrays.asList(new ResourceLocation("openblocks", "beartrap"), new ResourceLocation("thaumictinkerer", "magnet"));
    private boolean spawnLandmines = false;
    private boolean spawnPixies = false;
    private boolean anyWithArmor = false;
    private boolean aggro = false;
    private int tpDelay = 0;
    private int mobSpawnTicks = 0;
    private int playerCount = 0;
    private boolean hardMode = false;
    private BlockPos source = ManaBurst.NO_SOURCE;
    private final List<UUID> playersWhoAttacked = new ArrayList<UUID>();
    private final ServerBossEvent bossInfo = (ServerBossEvent)new ServerBossEvent(BotaniaEntities.DOPPLEGANGER.getDescription(), BossEvent.BossBarColor.PINK, BossEvent.BossBarOverlay.PROGRESS).setCreateWorldFog(true);
    private UUID bossInfoUUID = this.bossInfo.getId();
    public Player trueKiller = null;

    public GaiaGuardianEntity(EntityType<GaiaGuardianEntity> type, Level world) {
        super(type, world);
        this.xpReward = 825;
        if (world.isClientSide) {
            Proxy.INSTANCE.addBoss(this);
        }
    }

    public static boolean spawn(Player player, ItemStack stack, Level world, BlockPos pos, boolean hard) {
        if (!(world.getBlockEntity(pos) instanceof BeaconBlockEntity) || !PlayerHelper.isTruePlayer((Entity)player) || GaiaGuardianEntity.countGaiaGuardiansAround(world, pos) > 0) {
            return false;
        }
        if (world.getDifficulty() == Difficulty.PEACEFUL) {
            if (!world.isClientSide) {
                player.sendSystemMessage((Component)Component.translatable((String)"botaniamisc.peacefulNoob").withStyle(ChatFormatting.RED));
            }
            return false;
        }
        List<BlockPos> invalidPylonBlocks = GaiaGuardianEntity.checkPylons(world, pos);
        if (!invalidPylonBlocks.isEmpty()) {
            if (world.isClientSide) {
                GaiaGuardianEntity.warnInvalidBlocks(world, invalidPylonBlocks);
            } else {
                player.sendSystemMessage((Component)Component.translatable((String)"botaniamisc.needsCatalysts").withStyle(ChatFormatting.RED));
            }
            return false;
        }
        List<BlockPos> invalidArenaBlocks = GaiaGuardianEntity.checkArena(world, pos);
        if (!invalidArenaBlocks.isEmpty()) {
            if (world.isClientSide) {
                GaiaGuardianEntity.warnInvalidBlocks(world, invalidArenaBlocks);
            } else {
                XplatAbstractions.INSTANCE.sendToPlayer(player, new BotaniaEffectPacket(EffectType.ARENA_INDICATOR, pos.getX(), pos.getY(), pos.getZ(), new int[0]));
                player.sendSystemMessage((Component)Component.translatable((String)"botaniamisc.badArena").withStyle(ChatFormatting.RED));
            }
            return false;
        }
        if (!world.isClientSide) {
            int playerCount;
            stack.shrink(1);
            GaiaGuardianEntity e = (GaiaGuardianEntity)BotaniaEntities.DOPPLEGANGER.create(world);
            e.setPos((double)pos.getX() + 0.5, pos.getY() + 3, (double)pos.getZ() + 0.5);
            e.setInvulTime(160);
            e.setHealth(1.0f);
            e.bossInfo.setProgress(0.0f);
            e.source = pos;
            e.mobSpawnTicks = 900;
            e.hardMode = hard;
            List<Player> playersAround = e.getPlayersAround();
            e.playerCount = playerCount = playersAround.size();
            float healthMultiplier = 1.0f;
            if (playerCount > 1) {
                healthMultiplier += (float)playerCount * 0.25f;
            }
            e.getAttribute(Attributes.MAX_HEALTH).setBaseValue((double)(320.0f * healthMultiplier));
            if (hard) {
                e.getAttribute(Attributes.ARMOR).setBaseValue(15.0);
            }
            e.playSound(BotaniaSounds.gaiaSummon, 1.0f, 1.0f);
            e.finalizeSpawn((ServerLevelAccessor)world, world.getCurrentDifficultyAt(e.blockPosition()), MobSpawnType.EVENT, null, null);
            world.addFreshEntity((Entity)e);
            for (Player nearbyPlayer : playersAround) {
                if (!(nearbyPlayer instanceof ServerPlayer)) continue;
                ServerPlayer serverPlayer = (ServerPlayer)nearbyPlayer;
                CriteriaTriggers.SUMMONED_ENTITY.trigger(serverPlayer, (Entity)e);
            }
        }
        return true;
    }

    private static List<BlockPos> checkPylons(Level world, BlockPos beaconPos) {
        ArrayList<BlockPos> invalidPylonBlocks = new ArrayList<BlockPos>();
        for (BlockPos coords : PYLON_LOCATIONS) {
            BlockPos pos_ = beaconPos.offset((Vec3i)coords);
            BlockState state = world.getBlockState(pos_);
            if (state.is(BotaniaBlocks.gaiaPylon)) continue;
            invalidPylonBlocks.add(pos_);
        }
        return invalidPylonBlocks;
    }

    private static List<BlockPos> checkArena(Level world, BlockPos beaconPos) {
        ArrayList<BlockPos> trippedPositions = new ArrayList<BlockPos>();
        int range = (int)Math.ceil(12.0);
        for (int x = -range; x <= range; ++x) {
            for (int z = -range; z <= range; ++z) {
                if (Math.abs(x) == 4 && Math.abs(z) == 4 || MathHelper.pointDistancePlane(x, z, 0.0, 0.0) > 12.0f) continue;
                boolean hasFloor = false;
                for (int y = -2; y <= 5; ++y) {
                    boolean isBlockHere;
                    if (x == 0 && y == 0 && z == 0) continue;
                    BlockPos pos = beaconPos.offset(x, y, z);
                    BlockState state = world.getBlockState(pos);
                    boolean allowBlockHere = y < 0;
                    boolean bl = isBlockHere = !state.getCollisionShape((BlockGetter)world, pos).isEmpty();
                    if (allowBlockHere && isBlockHere) {
                        hasFloor = true;
                    }
                    if (y == 0 && !hasFloor) {
                        trippedPositions.add(pos.below());
                    }
                    if (allowBlockHere || !isBlockHere || state.is(BLACKLIST)) continue;
                    trippedPositions.add(pos);
                }
            }
        }
        return trippedPositions;
    }

    private static void warnInvalidBlocks(Level world, Iterable<BlockPos> invalidPositions) {
        WispParticleData data = WispParticleData.wisp(0.5f, 1.0f, 0.2f, 0.2f, 8.0f, false);
        for (BlockPos pos_ : invalidPositions) {
            world.addParticle((ParticleOptions)data, (double)pos_.getX() + 0.5, (double)pos_.getY() + 0.5, (double)pos_.getZ() + 0.5, 0.0, 0.0, 0.0);
        }
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 18.0f));
    }

    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(INVUL_TIME, (Object)0);
    }

    public int getInvulTime() {
        return (Integer)this.entityData.get(INVUL_TIME);
    }

    public BlockPos getSource() {
        return this.source;
    }

    public void setInvulTime(int time) {
        this.entityData.set(INVUL_TIME, (Object)time);
    }

    public void addAdditionalSaveData(CompoundTag cmp) {
        super.addAdditionalSaveData(cmp);
        cmp.putInt(TAG_INVUL_TIME, this.getInvulTime());
        cmp.putBoolean(TAG_AGGRO, this.aggro);
        cmp.putInt(TAG_MOB_SPAWN_TICKS, this.mobSpawnTicks);
        cmp.putInt(TAG_SOURCE_X, this.source.getX());
        cmp.putInt(TAG_SOURCE_Y, this.source.getY());
        cmp.putInt(TAG_SOURCE_Z, this.source.getZ());
        cmp.putBoolean(TAG_HARD_MODE, this.hardMode);
        cmp.putInt(TAG_PLAYER_COUNT, this.playerCount);
    }

    public void readAdditionalSaveData(CompoundTag cmp) {
        super.readAdditionalSaveData(cmp);
        this.setInvulTime(cmp.getInt(TAG_INVUL_TIME));
        this.aggro = cmp.getBoolean(TAG_AGGRO);
        this.mobSpawnTicks = cmp.getInt(TAG_MOB_SPAWN_TICKS);
        int x = cmp.getInt(TAG_SOURCE_X);
        int y = cmp.getInt(TAG_SOURCE_Y);
        int z = cmp.getInt(TAG_SOURCE_Z);
        this.source = new BlockPos(x, y, z);
        this.hardMode = cmp.getBoolean(TAG_HARD_MODE);
        this.playerCount = cmp.contains(TAG_PLAYER_COUNT) ? cmp.getInt(TAG_PLAYER_COUNT) : 1;
        if (this.hasCustomName()) {
            this.bossInfo.setName(this.getDisplayName());
        }
    }

    public void setCustomName(@Nullable Component name) {
        super.setCustomName(name);
        this.bossInfo.setName(this.getDisplayName());
    }

    public void heal(float amount) {
        if (this.getInvulTime() == 0) {
            super.heal(amount);
        }
    }

    public void kill() {
        this.setHealth(0.0f);
    }

    public boolean hurt(@NotNull DamageSource source, float amount) {
        Entity e = source.getEntity();
        if (e instanceof Player) {
            Player player = (Player)e;
            if (PlayerHelper.isTruePlayer(e) && this.getInvulTime() == 0) {
                if (!this.playersWhoAttacked.contains(player.getUUID())) {
                    this.playersWhoAttacked.add(player.getUUID());
                }
                return super.hurt(source, Math.min(32.0f, amount));
            }
        }
        return false;
    }

    protected void actuallyHurt(@NotNull DamageSource source, float amount) {
        super.actuallyHurt(source, Math.min(32.0f, amount));
        Entity attacker = source.getDirectEntity();
        if (attacker != null) {
            Vec3 thisVector = VecHelper.fromEntityCenter((Entity)this);
            Vec3 playerVector = VecHelper.fromEntityCenter(attacker);
            Vec3 motionVector = thisVector.subtract(playerVector).normalize().scale(0.75);
            if (this.getHealth() > 0.0f) {
                this.setDeltaMovement(-motionVector.x, 0.5, -motionVector.z);
                this.tpDelay = 4;
                this.spawnPixies = true;
            }
        }
        this.invulnerableTime = Math.max(this.invulnerableTime, 20);
    }

    protected float getDamageAfterArmorAbsorb(DamageSource source, float damage) {
        return super.getDamageAfterArmorAbsorb(source, Math.min(32.0f, damage));
    }

    public void die(@NotNull DamageSource source) {
        super.die(source);
        LivingEntity lastAttacker = this.getKillCredit();
        if (!this.level().isClientSide) {
            for (UUID u : this.playersWhoAttacked) {
                DamageSource currSource;
                Player player = this.level().getPlayerByUUID(u);
                if (!PlayerHelper.isTruePlayer((Entity)player)) continue;
                DamageSource damageSource = currSource = player == lastAttacker ? source : player.damageSources().playerAttack(player);
                if (player != lastAttacker) {
                    CriteriaTriggers.PLAYER_KILLED_ENTITY.trigger((ServerPlayer)player, (Entity)this, currSource);
                }
                if (this.anyWithArmor) continue;
                GaiaGuardianNoArmorTrigger.INSTANCE.trigger((ServerPlayer)player, this, currSource);
            }
            for (Player player : this.getPlayersAround()) {
                if (player.getEffect(MobEffects.WITHER) == null) continue;
                player.removeEffect(MobEffects.WITHER);
            }
            for (PixieEntity pixie : this.level().getEntitiesOfClass(PixieEntity.class, GaiaGuardianEntity.getArenaBB(this.getSource()), p -> p.isAlive() && p.getPixieType() == 1)) {
                pixie.spawnAnim();
                pixie.discard();
            }
            for (MagicLandmineEntity landmine : this.level().getEntitiesOfClass(MagicLandmineEntity.class, GaiaGuardianEntity.getArenaBB(this.getSource()))) {
                landmine.discard();
            }
        }
        this.playSound(BotaniaSounds.gaiaDeath, 1.0f, (1.0f + (this.level().random.nextFloat() - this.level().random.nextFloat()) * 0.2f) * 0.7f);
        this.level().addParticle((ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, this.getX(), this.getY(), this.getZ(), 1.0, 0.0, 0.0);
    }

    public boolean removeWhenFarAway(double dist) {
        return false;
    }

    public ResourceLocation getDefaultLootTable() {
        if (this.mobSpawnTicks > 0) {
            return BuiltInLootTables.EMPTY;
        }
        return ResourceLocationHelper.prefix(this.hardMode ? "gaia_guardian_2" : "gaia_guardian");
    }

    protected void dropFromLootTable(@NotNull DamageSource source, boolean wasRecentlyHit) {
        if (wasRecentlyHit && PlayerHelper.isTruePlayer(source.getEntity())) {
            this.trueKiller = (Player)source.getEntity();
        }
        for (UUID u : this.playersWhoAttacked) {
            Player player = this.level().getPlayerByUUID(u);
            if (!PlayerHelper.isTruePlayer((Entity)player)) continue;
            Player saveLastAttacker = this.lastHurtByPlayer;
            Vec3 savePos = this.position();
            this.lastHurtByPlayer = player;
            this.setPos(player.getX(), player.getY(), player.getZ());
            super.dropFromLootTable(player.damageSources().playerAttack(player), wasRecentlyHit);
            this.setPos(savePos.x(), savePos.y(), savePos.z());
            this.lastHurtByPlayer = saveLastAttacker;
        }
        this.trueKiller = null;
    }

    public void remove(Entity.RemovalReason reason) {
        if (this.level().isClientSide) {
            Proxy.INSTANCE.removeBoss(this);
        }
        super.remove(reason);
    }

    public List<Player> getPlayersAround() {
        return PlayerHelper.getRealPlayersIn(this.level(), GaiaGuardianEntity.getArenaBB(this.source));
    }

    public int getPlayerCount() {
        return this.playerCount;
    }

    private static int countGaiaGuardiansAround(Level world, BlockPos source) {
        List l = world.getEntitiesOfClass(GaiaGuardianEntity.class, GaiaGuardianEntity.getArenaBB(source));
        return l.size();
    }

    @NotNull
    private static AABB getArenaBB(@NotNull BlockPos source) {
        double range = 15.0;
        return new AABB((double)source.getX() + 0.5 - range, (double)source.getY() + 0.5 - range, (double)source.getZ() + 0.5 - range, (double)source.getX() + 0.5 + range, (double)source.getY() + 0.5 + range, (double)source.getZ() + 0.5 + range);
    }

    private void particles() {
        float rad;
        for (int i = 0; i < 360; i += 8) {
            float r = 0.6f;
            float g = 0.0f;
            float b = 0.2f;
            float m = 0.15f;
            float mv = 0.35f;
            rad = (float)i * (float)Math.PI / 180.0f;
            double x = (double)this.source.getX() + 0.5 - Math.cos(rad) * 12.0;
            double y = (double)this.source.getY() + 0.5;
            double z = (double)this.source.getZ() + 0.5 - Math.sin(rad) * 12.0;
            WispParticleData data = WispParticleData.wisp(0.5f, r, g, b);
            this.level().addParticle((ParticleOptions)data, x, y, z, (double)((float)(Math.random() - 0.5) * m), (double)((float)(Math.random() - 0.5) * mv), (double)((float)(Math.random() - 0.5) * m));
        }
        if (this.getInvulTime() > 10) {
            Vec3 pos = VecHelper.fromEntityCenter((Entity)this).subtract(0.0, 0.2, 0.0);
            for (BlockPos arr : PYLON_LOCATIONS) {
                Vec3 pylonPos = new Vec3((double)(this.source.getX() + arr.getX()), (double)(this.source.getY() + arr.getY()), (double)(this.source.getZ() + arr.getZ()));
                double worldTime = this.tickCount;
                rad = 0.75f + (float)Math.random() * 0.05f;
                double xp = pylonPos.x + 0.5 + Math.cos(worldTime /= 5.0) * (double)rad;
                double zp = pylonPos.z + 0.5 + Math.sin(worldTime) * (double)rad;
                Vec3 partPos = new Vec3(xp, pylonPos.y, zp);
                Vec3 mot = pos.subtract(partPos).scale(0.04);
                float r = 0.7f + (float)Math.random() * 0.3f;
                float g = (float)Math.random() * 0.3f;
                float b = 0.7f + (float)Math.random() * 0.3f;
                WispParticleData data = WispParticleData.wisp(0.25f + (float)Math.random() * 0.1f, r, g, b, 1.0f);
                this.level().addParticle((ParticleOptions)data, partPos.x, partPos.y, partPos.z, 0.0, (double)(-(-0.075f - (float)Math.random() * 0.015f)), 0.0);
                WispParticleData data1 = WispParticleData.wisp(0.4f, r, g, b);
                this.level().addParticle((ParticleOptions)data1, partPos.x, partPos.y, partPos.z, (double)((float)mot.x), (double)((float)mot.y), (double)((float)mot.z));
            }
        }
    }

    private void smashBlocksAround(int centerX, int centerY, int centerZ, int radius) {
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius + 1; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    int x = centerX + dx;
                    int y = centerY + dy;
                    int z = centerZ + dz;
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState state = this.level().getBlockState(pos);
                    Block block = state.getBlock();
                    if (state.getDestroySpeed((BlockGetter)this.level(), pos) == -1.0f) continue;
                    if (CHEATY_BLOCKS.contains(BuiltInRegistries.BLOCK.getKey((Object)block))) {
                        this.level().destroyBlock(pos, true);
                        continue;
                    }
                    if (state.is(BLACKLIST) || y < this.source.getY() || Math.abs(this.source.getX() - x) == 4 && Math.abs(this.source.getZ() - z) == 4) continue;
                    this.level().destroyBlock(pos, true);
                }
            }
        }
    }

    private void clearPotions(Player player) {
        HashSet<MobEffect> effectsToRemove = new HashSet<MobEffect>();
        for (MobEffectInstance effectInstance : player.getActiveEffects()) {
            if (effectInstance.getDuration() >= 160 || !effectInstance.isAmbient() || effectInstance.getEffect().getCategory() == MobEffectCategory.HARMFUL) continue;
            effectsToRemove.add(effectInstance.getEffect());
        }
        for (MobEffect effect : effectsToRemove) {
            player.removeEffect(effect);
            ((ServerLevel)this.level()).getChunkSource().broadcastAndSend((Entity)player, (Packet)new ClientboundRemoveMobEffectPacket(player.getId(), effect));
        }
    }

    private void keepInsideArena(Player player) {
        if (MathHelper.pointDistanceSpace(player.getX(), player.getY(), player.getZ(), (double)this.source.getX() + 0.5, (double)this.source.getY() + 0.5, (double)this.source.getZ() + 0.5) >= 12.0f) {
            Vec3 sourceVector = new Vec3((double)this.source.getX() + 0.5, (double)this.source.getY() + 0.5, (double)this.source.getZ() + 0.5);
            Vec3 playerVector = VecHelper.fromEntityCenter((Entity)player);
            Vec3 motion = sourceVector.subtract(playerVector).normalize();
            player.setDeltaMovement(motion.x, 0.2, motion.z);
            player.hurtMarked = true;
        }
    }

    private void spawnMobs(List<Player> players) {
        for (int pl = 0; pl < this.playerCount; ++pl) {
            for (int i = 0; i < 3 + this.level().random.nextInt(2); ++i) {
                WitherSkeleton entity;
                switch (this.level().random.nextInt(3)) {
                    case 0: {
                        WitherSkeleton witherSkeleton;
                        if (this.level().random.nextInt(this.hardMode ? 3 : 12) == 0) {
                            witherSkeleton = (Witch)EntityType.WITCH.create(this.level());
                            break;
                        }
                        witherSkeleton = (Zombie)EntityType.ZOMBIE.create(this.level());
                        break;
                    }
                    case 1: {
                        WitherSkeleton witherSkeleton;
                        if (this.level().random.nextInt(8) == 0) {
                            witherSkeleton = (WitherSkeleton)EntityType.WITHER_SKELETON.create(this.level());
                            break;
                        }
                        witherSkeleton = (Skeleton)EntityType.SKELETON.create(this.level());
                        break;
                    }
                    case 2: {
                        if (!players.isEmpty()) {
                            for (int j = 0; j < 1 + this.level().random.nextInt(this.hardMode ? 8 : 5); ++j) {
                                PixieEntity pixie = new PixieEntity(this.level());
                                pixie.setProps((LivingEntity)players.get(this.random.nextInt(players.size())), (LivingEntity)this, 1, 8.0f);
                                pixie.setPos(this.getX() + (double)(this.getBbWidth() / 2.0f), this.getY() + 2.0, this.getZ() + (double)(this.getBbWidth() / 2.0f));
                                pixie.finalizeSpawn((ServerLevelAccessor)this.level(), this.level().getCurrentDifficultyAt(pixie.blockPosition()), MobSpawnType.MOB_SUMMONED, null, null);
                                this.level().addFreshEntity((Entity)pixie);
                            }
                        }
                        WitherSkeleton witherSkeleton = null;
                        break;
                    }
                    default: {
                        WitherSkeleton witherSkeleton = entity = null;
                    }
                }
                if (entity == null) continue;
                if (!entity.fireImmune()) {
                    entity.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 600, 0));
                }
                float range = 6.0f;
                entity.setPos(this.getX() + 0.5 + Math.random() * (double)range - (double)(range / 2.0f), this.getY() - 1.0, this.getZ() + 0.5 + Math.random() * (double)range - (double)(range / 2.0f));
                entity.finalizeSpawn((ServerLevelAccessor)this.level(), this.level().getCurrentDifficultyAt(entity.blockPosition()), MobSpawnType.MOB_SUMMONED, null, null);
                if (entity instanceof WitherSkeleton && this.hardMode) {
                    entity.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)BotaniaItems.elementiumSword));
                }
                this.level().addFreshEntity((Entity)entity);
            }
        }
    }

    public void aiStep() {
        boolean spawnMissiles;
        super.aiStep();
        int invul = this.getInvulTime();
        if (this.level().isClientSide) {
            this.particles();
            Player player = Proxy.INSTANCE.getClientPlayer();
            if (this.getPlayersAround().contains(player)) {
                player.getAbilities().flying &= player.getAbilities().instabuild;
            }
            return;
        }
        this.bossInfo.setProgress(this.getHealth() / this.getMaxHealth());
        if (this.isPassenger()) {
            this.stopRiding();
        }
        if (this.level().getDifficulty() == Difficulty.PEACEFUL) {
            this.discard();
        }
        this.smashBlocksAround(Mth.floor((double)this.getX()), Mth.floor((double)this.getY()), Mth.floor((double)this.getZ()), 1);
        List<Player> players = this.getPlayersAround();
        if (players.isEmpty() && !this.level().players().isEmpty()) {
            this.discard();
        } else {
            for (Player player : players) {
                for (EquipmentSlot e : EquipmentSlot.values()) {
                    if (e.getType() != EquipmentSlot.Type.ARMOR || player.getItemBySlot(e).isEmpty()) continue;
                    this.anyWithArmor = true;
                    break;
                }
                if (player.isSleeping()) {
                    player.stopSleeping();
                }
                this.clearPotions(player);
                this.keepInsideArena(player);
                player.getAbilities().flying &= player.getAbilities().instabuild;
            }
        }
        if (!this.isAlive() || players.isEmpty()) {
            return;
        }
        boolean bl = spawnMissiles = this.hardMode && this.tickCount % 15 < 4;
        if (invul > 0 && this.mobSpawnTicks == 900) {
            if (invul < 160 && invul > 80 && this.level().random.nextInt(160 - invul + 1) == 0) {
                for (int i = 0; i < 2; ++i) {
                    this.spawnAnim();
                }
            }
            this.setHealth(this.getHealth() + (this.getMaxHealth() - 1.0f) / 160.0f);
            this.setInvulTime(invul - 1);
            this.setDeltaMovement(this.getDeltaMovement().x(), 0.0, this.getDeltaMovement().z());
        } else if (this.aggro) {
            boolean dying;
            boolean bl2 = dying = (double)(this.getHealth() / this.getMaxHealth()) < 0.2;
            if (dying && this.mobSpawnTicks > 0) {
                this.setDeltaMovement(Vec3.ZERO);
                int reverseTicks = 900 - this.mobSpawnTicks;
                if (reverseTicks < 20) {
                    this.setDeltaMovement(this.getDeltaMovement().x(), 0.2, this.getDeltaMovement().z());
                    this.setInvulTime(invul + 1);
                }
                if (reverseTicks > 40 && this.mobSpawnTicks > 80 && this.mobSpawnTicks % 80 == 0) {
                    this.spawnMobs(players);
                    if (this.hardMode && this.tickCount % 3 < 2) {
                        for (i = 0; i < this.playerCount; ++i) {
                            this.spawnMissile();
                        }
                        spawnMissiles = false;
                    }
                }
                --this.mobSpawnTicks;
                this.tpDelay = 10;
            } else if (this.tpDelay > 0) {
                if (invul > 0) {
                    this.setInvulTime(invul - 1);
                }
                --this.tpDelay;
                if (this.tpDelay == 0 && this.getHealth() > 0.0f) {
                    this.teleportRandomly();
                    if (this.spawnLandmines) {
                        int count = dying && this.hardMode ? 7 : 6;
                        for (i = 0; i < count; ++i) {
                            int x = this.source.getX() - 10 + this.random.nextInt(20);
                            int y = (int)players.get(this.random.nextInt(players.size())).getY();
                            int z = this.source.getZ() - 10 + this.random.nextInt(20);
                            MagicLandmineEntity landmine = (MagicLandmineEntity)BotaniaEntities.MAGIC_LANDMINE.create(this.level());
                            landmine.setPos((double)x + 0.5, y, (double)z + 0.5);
                            landmine.summoner = this;
                            this.level().addFreshEntity((Entity)landmine);
                        }
                    }
                    for (int pl = 0; pl < this.playerCount; ++pl) {
                        for (i = 0; i < (this.spawnPixies ? this.level().random.nextInt(this.hardMode ? 6 : 3) : 1); ++i) {
                            PixieEntity pixie = new PixieEntity(this.level());
                            pixie.setProps((LivingEntity)players.get(this.random.nextInt(players.size())), (LivingEntity)this, 1, 8.0f);
                            pixie.setPos(this.getX() + (double)(this.getBbWidth() / 2.0f), this.getY() + 2.0, this.getZ() + (double)(this.getBbWidth() / 2.0f));
                            pixie.finalizeSpawn((ServerLevelAccessor)this.level(), this.level().getCurrentDifficultyAt(pixie.blockPosition()), MobSpawnType.MOB_SUMMONED, null, null);
                            this.level().addFreshEntity((Entity)pixie);
                        }
                    }
                    this.tpDelay = this.hardMode ? (dying ? 35 : 45) : (dying ? 40 : 60);
                    this.spawnLandmines = true;
                    this.spawnPixies = false;
                }
            } else {
                this.tpDelay = 30;
            }
            if (spawnMissiles) {
                this.spawnMissile();
            }
        } else {
            this.tpDelay = 30;
            this.aggro = true;
        }
    }

    public boolean canChangeDimensions() {
        return false;
    }

    public void startSeenByPlayer(ServerPlayer player) {
        super.startSeenByPlayer(player);
        this.bossInfo.addPlayer(player);
    }

    public void stopSeenByPlayer(ServerPlayer player) {
        super.stopSeenByPlayer(player);
        this.bossInfo.removePlayer(player);
    }

    protected void pushEntities() {
        if (this.getInvulTime() == 0) {
            super.pushEntities();
        }
    }

    public boolean isPushable() {
        return super.isPushable() && this.getInvulTime() == 0;
    }

    private void spawnMissile() {
        MagicMissileEntity missile = new MagicMissileEntity((LivingEntity)this, true);
        missile.setPos(this.getX() + (Math.random() - 0.05), this.getY() + 2.4 + (Math.random() - 0.05), this.getZ() + (Math.random() - 0.05));
        if (missile.findTarget()) {
            this.playSound(BotaniaSounds.missile, 1.0f, 0.8f + (float)Math.random() * 0.2f);
            this.level().addFreshEntity((Entity)missile);
        }
    }

    private void teleportRandomly() {
        Vec3 newPosVec;
        double newZ;
        double newX;
        double oldX = this.getX();
        double oldY = this.getY();
        double oldZ = this.getZ();
        double newY = this.source.getY();
        int tries = 0;
        do {
            newX = (double)this.source.getX() + (this.random.nextDouble() - 0.5) * 12.0;
            newZ = (double)this.source.getZ() + (this.random.nextDouble() - 0.5) * 12.0;
        } while (++tries < 50 && MathHelper.pointDistanceSpace(newX, newY, newZ, this.source.getX(), this.source.getY(), this.source.getZ()) > 12.0f);
        if (tries == 50) {
            newX = (double)this.source.getX() + 0.5;
            newY = (double)this.source.getY() + 1.6;
            newZ = (double)this.source.getZ() + 0.5;
        }
        BlockPos tentativeFloorPos = BlockPos.containing((double)newX, (double)(newY - 1.0), (double)newZ);
        if (this.level().getBlockState(tentativeFloorPos).getCollisionShape((BlockGetter)this.level(), tentativeFloorPos).isEmpty()) {
            newY -= 1.0;
        }
        this.teleportTo(newX, newY, newZ);
        this.level().playSound(null, oldX, oldY, oldZ, BotaniaSounds.gaiaTeleport, this.getSoundSource(), 1.0f, 1.0f);
        this.playSound(BotaniaSounds.gaiaTeleport, 1.0f, 1.0f);
        RandomSource random = this.getRandom();
        int particleCount = 128;
        for (int i = 0; i < particleCount; ++i) {
            double progress = (double)i / (double)(particleCount - 1);
            float vx = (random.nextFloat() - 0.5f) * 0.2f;
            float vy = (random.nextFloat() - 0.5f) * 0.2f;
            float vz = (random.nextFloat() - 0.5f) * 0.2f;
            double px = oldX + (newX - oldX) * progress + (random.nextDouble() - 0.5) * (double)this.getBbWidth() * 2.0;
            double py = oldY + (newY - oldY) * progress + random.nextDouble() * (double)this.getBbHeight();
            double pz = oldZ + (newZ - oldZ) * progress + (random.nextDouble() - 0.5) * (double)this.getBbWidth() * 2.0;
            this.level().addParticle((ParticleOptions)ParticleTypes.PORTAL, px, py, pz, (double)vx, (double)vy, (double)vz);
        }
        Vec3 oldPosVec = new Vec3(oldX, oldY + (double)(this.getBbHeight() / 2.0f), oldZ);
        if (oldPosVec.distanceToSqr(newPosVec = new Vec3(newX, newY + (double)(this.getBbHeight() / 2.0f), newZ)) > 1.0) {
            for (Player player : this.getPlayersAround()) {
                boolean hit = player.getBoundingBox().inflate(0.25).clip(oldPosVec, newPosVec).isPresent();
                if (!hit) continue;
                player.hurt(this.damageSources().mobAttack((LivingEntity)this), 6.0f);
            }
            int breakSteps = (int)oldPosVec.distanceTo(newPosVec);
            if (breakSteps >= 2) {
                for (int i = 0; i < breakSteps; ++i) {
                    float progress = (float)i / (float)(breakSteps - 1);
                    int breakX = Mth.floor((double)(oldX + (newX - oldX) * (double)progress));
                    int breakY = Mth.floor((double)(oldY + (newY - oldY) * (double)progress));
                    int breakZ = Mth.floor((double)(oldZ + (newZ - oldZ) * (double)progress));
                    this.smashBlocksAround(breakX, breakY, breakZ, 1);
                }
            }
        }
    }

    public UUID getBossInfoUuid() {
        return this.bossInfoUUID;
    }

    public boolean isHardMode() {
        return this.hardMode;
    }

    public void readSpawnData(int playerCount, boolean hardMode, BlockPos source, UUID bossInfoUUID) {
        this.playerCount = playerCount;
        this.hardMode = hardMode;
        this.source = source;
        this.bossInfoUUID = bossInfoUUID;
        Proxy.INSTANCE.runOnClient(() -> () -> DopplegangerMusic.play(this));
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket() {
        return XplatAbstractions.INSTANCE.toVanillaClientboundPacket(new SpawnGaiaGuardianPacket(new ClientboundAddEntityPacket((Entity)this), this.playerCount, this.hardMode, this.source, this.bossInfoUUID));
    }

    public boolean canBeLeashed(Player player) {
        return false;
    }

    private static class DopplegangerMusic
    extends AbstractTickableSoundInstance {
        private final GaiaGuardianEntity guardian;

        private DopplegangerMusic(GaiaGuardianEntity guardian) {
            super(guardian.hardMode ? BotaniaSounds.gaiaMusic2 : BotaniaSounds.gaiaMusic1, SoundSource.RECORDS, SoundInstance.createUnseededRandom());
            this.guardian = guardian;
            this.x = guardian.getSource().getX();
            this.y = guardian.getSource().getY();
            this.z = guardian.getSource().getZ();
            this.looping = true;
        }

        public static void play(GaiaGuardianEntity guardian) {
            Minecraft.getInstance().getSoundManager().play((SoundInstance)new DopplegangerMusic(guardian));
        }

        public void tick() {
            if (!this.guardian.isAlive()) {
                this.stop();
            }
        }
    }
}

