/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.red_string;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.red_string.RedStringBlockEntity;
import vazkii.botania.common.block.block_entity.red_string.RedStringDispenserBlockEntity;
import vazkii.botania.common.block.red_string.RedStringBlock;

public class RedStringDispenserBlock
extends RedStringBlock {
    public RedStringDispenserBlock(BlockBehaviour.Properties builder) {
        super(builder);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN)).setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.POWERED});
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        boolean power = world.getBestNeighborSignal(pos) > 0;
        boolean powered = (Boolean)state.getValue((Property)BlockStateProperties.POWERED);
        if (power && !powered) {
            ((RedStringDispenserBlockEntity)world.getBlockEntity(pos)).tickDispenser();
            world.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(true)), 4);
        } else if (!power && powered) {
            world.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(false)), 4);
        }
    }

    @NotNull
    public RedStringBlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new RedStringDispenserBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return RedStringDispenserBlock.createTickerHelper(type, BotaniaBlockEntities.RED_STRING_DISPENSER, RedStringBlockEntity::commonTick);
    }
}

