/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.flower.functional;

import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.xplat.BotaniaConfig;

public class ClayconiaBlockEntity
extends FunctionalFlowerBlockEntity {
    private static final int COST = 80;
    private static final int RANGE = 5;
    private static final int RANGE_Y = 3;
    private static final int RANGE_MINI = 2;
    private static final int RANGE_Y_MINI = 1;

    protected ClayconiaBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public ClayconiaBlockEntity(BlockPos pos, BlockState state) {
        this(BotaniaFlowerBlocks.CLAYCONIA, pos, state);
    }

    @Override
    public void tickFlower() {
        BlockPos coords;
        super.tickFlower();
        if (!this.getLevel().isClientSide && this.ticksExisted % 5 == 0 && this.getMana() >= 80 && (coords = this.getCoordsToPut()) != null) {
            int stateId = Block.getId((BlockState)this.getLevel().getBlockState(coords));
            this.getLevel().removeBlock(coords, false);
            if (BotaniaConfig.common().blockBreakParticles()) {
                this.getLevel().levelEvent(2001, coords, stateId);
            }
            this.getLevel().gameEvent(null, GameEvent.BLOCK_DESTROY, coords);
            ItemEntity item = new ItemEntity(this.getLevel(), (double)coords.getX() + 0.5, (double)coords.getY() + 0.5, (double)coords.getZ() + 0.5, new ItemStack((ItemLike)Items.CLAY_BALL));
            this.getLevel().addFreshEntity((Entity)item);
            this.addMana(-80);
        }
    }

    public BlockPos getCoordsToPut() {
        ArrayList<BlockPos> possibleCoords = new ArrayList<BlockPos>();
        int range = this.getRange();
        int rangeY = this.getRangeY();
        for (int i = -range; i < range + 1; ++i) {
            for (int j = -rangeY; j < rangeY + 1; ++j) {
                for (int k = -range; k < range + 1; ++k) {
                    BlockPos pos = this.getEffectivePos().offset(i, j, k);
                    BlockState state = this.getLevel().getBlockState(pos);
                    if (!state.is(BlockTags.SAND)) continue;
                    possibleCoords.add(pos);
                }
            }
        }
        if (possibleCoords.isEmpty()) {
            return null;
        }
        return (BlockPos)possibleCoords.get(this.getLevel().random.nextInt(possibleCoords.size()));
    }

    @Override
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square(this.getEffectivePos(), this.getRange());
    }

    public int getRange() {
        return 5;
    }

    public int getRangeY() {
        return 3;
    }

    @Override
    public int getColor() {
        return 8095634;
    }

    @Override
    public int getMaxMana() {
        return 640;
    }

    public static class Mini
    extends ClayconiaBlockEntity {
        public Mini(BlockPos pos, BlockState state) {
            super(BotaniaFlowerBlocks.CLAYCONIA_CHIBI, pos, state);
        }

        @Override
        public int getRange() {
            return 2;
        }

        @Override
        public int getRangeY() {
            return 1;
        }
    }
}

