/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.block_entity;

import com.google.common.base.Predicates;
import com.google.common.base.Suppliers;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.ResourceLocationException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Clearable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block.WandHUD;
import vazkii.botania.api.block.Wandable;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.ManaPool;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.api.mana.spark.ManaSpark;
import vazkii.botania.api.mana.spark.SparkAttachable;
import vazkii.botania.api.mana.spark.SparkHelper;
import vazkii.botania.api.state.BotaniaStateProperties;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntity;
import vazkii.botania.common.block.block_entity.PylonBlockEntity;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.network.EffectType;
import vazkii.botania.network.clientbound.BotaniaEffectPacket;
import vazkii.botania.xplat.XplatAbstractions;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.IStateMatcher;
import vazkii.patchouli.api.PatchouliAPI;

public class ManaEnchanterBlockEntity
extends BotaniaBlockEntity
implements ManaReceiver,
SparkAttachable,
Wandable,
Clearable {
    private static final String TAG_STAGE = "stage";
    private static final String TAG_STAGE_TICKS = "stageTicks";
    private static final String TAG_STAGE_3_END_TICKS = "stage3EndTicks";
    private static final String TAG_MANA_REQUIRED = "manaRequired";
    private static final String TAG_MANA = "mana";
    private static final String TAG_ITEM = "item";
    private static final String TAG_ENCHANTS = "enchantsToApply";
    private static final int CRAFT_EFFECT_EVENT = 0;
    private static final int IDLE_CHECK_INTERVAL_TICKS = 10;
    private static final String[][] PATTERN = new String[][]{{"_P_______P_", "___________", "___________", "P_________P", "___________", "___________", "_P_______P_"}, {"_F_______F_", "___________", "____F_F____", "F____L____F", "____F_F____", "___________", "_F_______F_"}, {"___________", "____BBB____", "___B_B_B___", "___BB0BB___", "___B_B_B___", "____BBB____", "___________"}};
    private static final Supplier<IStateMatcher> OBSIDIAN_MATCHER = Suppliers.memoize(() -> PatchouliAPI.get().predicateMatcher(Blocks.OBSIDIAN, state -> state.is(Blocks.OBSIDIAN) || state.is(Blocks.CRYING_OBSIDIAN)));
    public static final Supplier<IMultiblock> MULTIBLOCK = Suppliers.memoize(() -> PatchouliAPI.get().makeMultiblock(PATTERN, new Object[]{Character.valueOf('P'), BotaniaBlocks.manaPylon, Character.valueOf('L'), Blocks.LAPIS_BLOCK, Character.valueOf('B'), OBSIDIAN_MATCHER.get(), Character.valueOf('0'), OBSIDIAN_MATCHER.get(), Character.valueOf('F'), PatchouliAPI.get().tagMatcher(BotaniaTags.Blocks.ENCHANTER_FLOWERS)}));
    private static final Supplier<IMultiblock> FORMED_MULTIBLOCK = Suppliers.memoize(() -> PatchouliAPI.get().makeMultiblock(PATTERN, new Object[]{Character.valueOf('P'), BotaniaBlocks.manaPylon, Character.valueOf('L'), BotaniaBlocks.enchanter, Character.valueOf('B'), OBSIDIAN_MATCHER.get(), Character.valueOf('0'), OBSIDIAN_MATCHER.get(), Character.valueOf('F'), PatchouliAPI.get().predicateMatcher(BotaniaBlocks.whiteFlower, state -> state.is(BotaniaTags.Blocks.ENCHANTER_FLOWERS))}));
    public State stage = State.IDLE;
    public int stageTicks = 0;
    public int stage3EndTicks = 0;
    private int idleTicks = 0;
    private int manaRequired = -1;
    private int mana = 0;
    public ItemStack itemToEnchant = ItemStack.EMPTY;
    private final List<EnchantmentInstance> enchants = new ArrayList<EnchantmentInstance>();
    private static final Map<Direction.Axis, BlockPos[]> PYLON_LOCATIONS = new EnumMap<Direction.Axis, BlockPos[]>(Direction.Axis.class);

    public ManaEnchanterBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaBlockEntities.ENCHANTER, pos, state);
    }

    @Override
    public boolean onUsedByWand(@Nullable Player player, ItemStack wand, Direction side) {
        if (this.stage != State.IDLE || this.itemToEnchant.isEmpty() || !this.itemToEnchant.isEnchantable()) {
            return false;
        }
        List items = this.level.getEntitiesOfClass(ItemEntity.class, new AABB((double)(this.worldPosition.getX() - 2), (double)this.worldPosition.getY(), (double)(this.worldPosition.getZ() - 2), (double)(this.worldPosition.getX() + 3), (double)(this.worldPosition.getY() + 1), (double)(this.worldPosition.getZ() + 3)));
        int count = items.size();
        if (count > 0 && !this.level.isClientSide) {
            for (ItemEntity entity : items) {
                Enchantment enchant;
                Map enchants;
                ItemStack item = entity.getItem();
                if (!item.is(Items.ENCHANTED_BOOK) || (enchants = EnchantmentHelper.getEnchantments((ItemStack)item)).size() <= 0 || !this.isEnchantmentValid(enchant = (Enchantment)enchants.keySet().iterator().next())) continue;
                this.advanceStage();
                return true;
            }
        }
        return false;
    }

    private void gatherEnchants() {
        if (!this.level.isClientSide && this.stageTicks % 20 == 0) {
            List items = this.level.getEntitiesOfClass(ItemEntity.class, new AABB((double)(this.worldPosition.getX() - 2), (double)this.worldPosition.getY(), (double)(this.worldPosition.getZ() - 2), (double)(this.worldPosition.getX() + 3), (double)(this.worldPosition.getY() + 1), (double)(this.worldPosition.getZ() + 3)));
            boolean addedEnch = false;
            for (ItemEntity entity : items) {
                Map enchants;
                ItemStack item = entity.getItem();
                if (!item.is(Items.ENCHANTED_BOOK) || (enchants = EnchantmentHelper.getEnchantments((ItemStack)item)).size() <= 0) continue;
                Map.Entry e = enchants.entrySet().iterator().next();
                Enchantment ench = (Enchantment)e.getKey();
                int enchantLvl = (Integer)e.getValue();
                if (this.hasEnchantAlready(ench) || !this.isEnchantmentValid(ench)) continue;
                this.enchants.add(new EnchantmentInstance(ench, enchantLvl));
                this.level.playSound(null, this.worldPosition, BotaniaSounds.ding, SoundSource.BLOCKS, 1.0f, 1.0f);
                addedEnch = true;
                break;
            }
            if (!addedEnch) {
                if (this.enchants.isEmpty()) {
                    this.stage = State.IDLE;
                } else {
                    this.advanceStage();
                }
            }
        }
    }

    private void gatherMana(Direction.Axis axis) {
        if (this.manaRequired == -1) {
            this.manaRequired = 0;
            for (EnchantmentInstance data : this.enchants) {
                this.manaRequired += (int)(5000.0f * ((float)(15 - Math.min(15, data.enchantment.getRarity().getWeight())) * 1.05f) * ((3.0f + (float)(data.level * data.level)) * 0.25f) * (0.9f + (float)this.enchants.size() * 0.05f) * (data.enchantment.isTreasureOnly() ? 1.25f : 1.0f));
            }
        } else if (this.mana >= this.manaRequired) {
            this.manaRequired = 0;
            for (BlockPos offset : PYLON_LOCATIONS.get(axis)) {
                BlockEntity te = this.level.getBlockEntity(this.worldPosition.offset((Vec3i)offset));
                if (!(te instanceof PylonBlockEntity)) continue;
                PylonBlockEntity pylon = (PylonBlockEntity)te;
                pylon.activated = false;
            }
            this.advanceStage();
        } else {
            ManaSpark spark = this.getAttachedSpark();
            if (spark != null) {
                List<ManaSpark> otherSparks = SparkHelper.getSparksAround(this.level, (double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5, spark.getNetwork());
                for (ManaSpark otherSpark : otherSparks) {
                    if (spark == otherSpark || !(otherSpark.getAttachedManaReceiver() instanceof ManaPool)) continue;
                    otherSpark.registerTransfer(spark);
                }
            }
            if (this.stageTicks % 5 == 0) {
                this.sync();
            }
        }
    }

    public static void commonTick(Level level, BlockPos worldPosition, BlockState state, ManaEnchanterBlockEntity self) {
        Direction.Axis axis = (Direction.Axis)state.getValue(BotaniaStateProperties.ENCHANTER_DIRECTION);
        for (BlockPos offset : PYLON_LOCATIONS.get(axis)) {
            boolean gatheringMana;
            BlockEntity tile = level.getBlockEntity(worldPosition.offset((Vec3i)offset));
            if (!(tile instanceof PylonBlockEntity)) continue;
            PylonBlockEntity pylon = (PylonBlockEntity)tile;
            pylon.activated = gatheringMana = self.stage == State.GATHER_MANA;
            if (!gatheringMana) continue;
            pylon.centerPos = worldPosition;
        }
        if (self.stage != State.IDLE) {
            ++self.stageTicks;
        } else {
            ++self.idleTicks;
        }
        if (level.isClientSide || self.stage == State.IDLE && self.idleTicks % 10 != 0) {
            return;
        }
        Rotation rot = ManaEnchanterBlockEntity.getAxisRotation(axis);
        if (!FORMED_MULTIBLOCK.get().validate(level, worldPosition.below(), rot)) {
            level.setBlockAndUpdate(worldPosition, Blocks.LAPIS_BLOCK.defaultBlockState());
            XplatAbstractions.INSTANCE.sendToNear(level, worldPosition, new BotaniaEffectPacket(EffectType.ENCHANTER_DESTROY, (double)worldPosition.getX() + 0.5, (double)worldPosition.getY() + 0.5, (double)worldPosition.getZ() + 0.5, new int[0]));
            level.playSound(null, worldPosition, BotaniaSounds.enchanterFade, SoundSource.BLOCKS, 1.0f, 1.0f);
            return;
        }
        switch (self.stage) {
            case GATHER_ENCHANTS: {
                self.gatherEnchants();
                break;
            }
            case GATHER_MANA: {
                self.gatherMana(axis);
                break;
            }
            case DO_ENCHANT: {
                if (self.stageTicks < 100) break;
                for (EnchantmentInstance data : self.enchants) {
                    if (EnchantmentHelper.getItemEnchantmentLevel((Enchantment)data.enchantment, (ItemStack)self.itemToEnchant) != 0) continue;
                    self.itemToEnchant.enchant(data.enchantment, data.level);
                }
                self.enchants.clear();
                self.manaRequired = -1;
                self.mana = 0;
                level.blockEvent(worldPosition, BotaniaBlocks.enchanter, 0, 0);
                self.advanceStage();
                break;
            }
            case RESET: {
                if (self.stageTicks < 20) break;
                self.advanceStage();
                break;
            }
        }
    }

    private void advanceStage() {
        switch (this.stage) {
            case IDLE: {
                this.stage = State.GATHER_ENCHANTS;
                break;
            }
            case GATHER_ENCHANTS: {
                this.stage = State.GATHER_MANA;
                break;
            }
            case GATHER_MANA: {
                this.stage = State.DO_ENCHANT;
                break;
            }
            case DO_ENCHANT: {
                this.stage = State.RESET;
                this.stage3EndTicks = this.stageTicks;
                break;
            }
            case RESET: {
                this.stage = State.IDLE;
                this.stage3EndTicks = 0;
            }
        }
        this.stageTicks = 0;
        this.sync();
    }

    public boolean triggerEvent(int event, int param) {
        switch (event) {
            case 0: {
                if (this.level.isClientSide) {
                    for (int i = 0; i < 25; ++i) {
                        float red = (float)Math.random();
                        float green = (float)Math.random();
                        float blue = (float)Math.random();
                        SparkleParticleData data = SparkleParticleData.sparkle((float)Math.random(), red, green, blue, 10);
                        this.level.addParticle((ParticleOptions)data, (double)this.getBlockPos().getX() + Math.random() * 0.4 - 0.2, (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ() + Math.random() * 0.4 - 0.2, 0.0, 0.0, 0.0);
                    }
                    this.level.playLocalSound((double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), BotaniaSounds.enchanterEnchant, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                }
                return true;
            }
        }
        return super.triggerEvent(event, param);
    }

    @Override
    public Level getManaReceiverLevel() {
        return this.getLevel();
    }

    @Override
    public BlockPos getManaReceiverPos() {
        return this.getBlockPos();
    }

    @Override
    public int getCurrentMana() {
        return this.mana;
    }

    @Override
    public boolean isFull() {
        return this.mana >= this.manaRequired;
    }

    @Override
    public void receiveMana(int mana) {
        this.mana = Math.min(this.manaRequired, this.mana + mana);
    }

    @Override
    public boolean canReceiveManaFromBursts() {
        return this.manaRequired > 0;
    }

    public void sync() {
        VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
    }

    @Override
    public void writePacketNBT(CompoundTag cmp) {
        cmp.putInt(TAG_MANA, this.mana);
        cmp.putInt(TAG_MANA_REQUIRED, this.manaRequired);
        cmp.putInt(TAG_STAGE, this.stage.ordinal());
        cmp.putInt(TAG_STAGE_TICKS, this.stageTicks);
        cmp.putInt(TAG_STAGE_3_END_TICKS, this.stage3EndTicks);
        CompoundTag itemCmp = new CompoundTag();
        if (!this.itemToEnchant.isEmpty()) {
            cmp.put(TAG_ITEM, (Tag)this.itemToEnchant.save(itemCmp));
        }
        String enchStr = this.enchants.stream().map(e -> BuiltInRegistries.ENCHANTMENT.getKey((Object)e.enchantment) + "=" + e.level).collect(Collectors.joining(","));
        cmp.putString(TAG_ENCHANTS, enchStr);
    }

    @Override
    public void readPacketNBT(CompoundTag cmp) {
        this.mana = cmp.getInt(TAG_MANA);
        this.manaRequired = cmp.getInt(TAG_MANA_REQUIRED);
        this.stage = State.values()[cmp.getInt(TAG_STAGE)];
        this.stageTicks = cmp.getInt(TAG_STAGE_TICKS);
        this.stage3EndTicks = cmp.getInt(TAG_STAGE_3_END_TICKS);
        CompoundTag itemCmp = cmp.getCompound(TAG_ITEM);
        this.itemToEnchant = ItemStack.of((CompoundTag)itemCmp);
        this.enchants.clear();
        String enchStr = cmp.getString(TAG_ENCHANTS);
        if (!enchStr.isEmpty()) {
            String[] enchTokens;
            for (String token : enchTokens = enchStr.split(",")) {
                try {
                    String[] entryTokens = token.split("=");
                    int lvl = Integer.parseInt(entryTokens[1]);
                    this.level.holderLookup(Registries.ENCHANTMENT).get(ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)new ResourceLocation(entryTokens[0]))).ifPresent(ench -> this.enchants.add(new EnchantmentInstance((Enchantment)ench.value(), lvl)));
                }
                catch (ResourceLocationException resourceLocationException) {
                    // empty catch block
                }
            }
        }
    }

    private boolean hasEnchantAlready(Enchantment enchant) {
        for (EnchantmentInstance data : this.enchants) {
            if (data.enchantment != enchant) continue;
            return true;
        }
        return false;
    }

    private boolean isEnchantmentValid(@Nullable Enchantment ench) {
        if (ench == null || !ench.canEnchant(this.itemToEnchant)) {
            return false;
        }
        for (EnchantmentInstance data : this.enchants) {
            Enchantment otherEnch = data.enchantment;
            if (ench.isCompatibleWith(otherEnch)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static Direction.Axis canEnchanterExist(Level world, BlockPos pos) {
        Rotation rot = MULTIBLOCK.get().validate(world, pos.below());
        if (rot == null) {
            return null;
        }
        return switch (rot) {
            default -> throw new IncompatibleClassChangeError();
            case Rotation.NONE, Rotation.CLOCKWISE_180 -> Direction.Axis.Z;
            case Rotation.CLOCKWISE_90, Rotation.COUNTERCLOCKWISE_90 -> Direction.Axis.X;
        };
    }

    private static Rotation getAxisRotation(Direction.Axis axis) {
        return switch (axis) {
            case Direction.Axis.Z -> Rotation.NONE;
            case Direction.Axis.X -> Rotation.CLOCKWISE_90;
            default -> throw new IllegalStateException("Enchanter should only ever be facing in X or Z direction");
        };
    }

    @Override
    public boolean canAttachSpark(ItemStack stack) {
        return true;
    }

    @Override
    public ManaSpark getAttachedSpark() {
        List sparks = this.level.getEntitiesOfClass(Entity.class, new AABB((double)this.worldPosition.getX(), (double)(this.worldPosition.getY() + 1), (double)this.worldPosition.getZ(), (double)(this.worldPosition.getX() + 1), (double)(this.worldPosition.getY() + 2), (double)(this.worldPosition.getZ() + 1)), (Predicate)Predicates.instanceOf(ManaSpark.class));
        if (sparks.size() == 1) {
            Entity e = (Entity)sparks.get(0);
            return (ManaSpark)e;
        }
        return null;
    }

    @Override
    public boolean areIncomingTranfersDone() {
        return this.stage == State.DO_ENCHANT;
    }

    @Override
    public int getAvailableSpaceForMana() {
        return Math.max(0, this.manaRequired - this.getCurrentMana());
    }

    public void clearContent() {
        this.itemToEnchant = ItemStack.EMPTY;
        this.stage = State.IDLE;
    }

    static {
        PYLON_LOCATIONS.put(Direction.Axis.X, new BlockPos[]{new BlockPos(-5, 1, 0), new BlockPos(5, 1, 0), new BlockPos(-4, 1, 3), new BlockPos(4, 1, 3), new BlockPos(-4, 1, -3), new BlockPos(4, 1, -3)});
        PYLON_LOCATIONS.put(Direction.Axis.Z, new BlockPos[]{new BlockPos(0, 1, -5), new BlockPos(0, 1, 5), new BlockPos(3, 1, -4), new BlockPos(3, 1, 4), new BlockPos(-3, 1, -4), new BlockPos(-3, 1, 4)});
    }

    public static enum State {
        IDLE,
        GATHER_ENCHANTS,
        GATHER_MANA,
        DO_ENCHANT,
        RESET;

    }

    public static class WandHud
    implements WandHUD {
        private final ManaEnchanterBlockEntity enchanter;

        public WandHud(ManaEnchanterBlockEntity enchanter) {
            this.enchanter = enchanter;
        }

        @Override
        public void renderHUD(GuiGraphics gui, Minecraft mc) {
            if (this.enchanter.manaRequired > 0 && !this.enchanter.itemToEnchant.isEmpty()) {
                int x = mc.getWindow().getGuiScaledWidth() / 2 + 8;
                int y = mc.getWindow().getGuiScaledHeight() / 2 - 12;
                RenderHelper.renderHUDBox(gui, x, y, x + 24, y + 24);
                RenderHelper.renderProgressPie(gui, x + 4, y + 4, (float)this.enchanter.mana / (float)this.enchanter.manaRequired, this.enchanter.itemToEnchant);
            }
        }
    }
}

