/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.client.core.handler.MiscellaneousModels;
import vazkii.botania.common.handler.ContributorList;

public final class ContributorFancinessHandler
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    public ContributorFancinessHandler(RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> renderer) {
        super(renderer);
    }

    public void render(PoseStack ms, MultiBufferSource buffers, int light, @NotNull AbstractClientPlayer player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack flower;
        ContributorList.firstStart();
        if (player.isInvisible()) {
            return;
        }
        String name = player.getGameProfile().getName();
        if (name.equals("haighyorkie")) {
            this.renderGoldfish(ms, buffers);
        }
        if (player.isModelPartShown(PlayerModelPart.CAPE) && !(flower = ContributorList.getFlower(name.toLowerCase(Locale.ROOT))).isEmpty()) {
            this.renderFlower(ms, buffers, (Player)player, flower);
        }
    }

    private void renderGoldfish(PoseStack ms, MultiBufferSource buffers) {
        ms.pushPose();
        ((PlayerModel)this.getParentModel()).head.translateAndRotate(ms);
        ms.translate(-0.15f, -0.6f, 0.0f);
        ms.scale(0.4f, -0.4f, -0.4f);
        Minecraft.getInstance().getBlockRenderer().getModelRenderer().renderModel(ms.last(), buffers.getBuffer(Sheets.translucentCullBlockSheet()), null, MiscellaneousModels.INSTANCE.goldfishModel, 1.0f, 1.0f, 1.0f, 0xF000F0, OverlayTexture.NO_OVERLAY);
        ms.popPose();
    }

    private void renderFlower(PoseStack ms, MultiBufferSource buffers, Player player, ItemStack flower) {
        ms.pushPose();
        ((PlayerModel)this.getParentModel()).head.translateAndRotate(ms);
        ms.translate(0.0, -0.75, 0.0);
        ms.scale(0.5f, -0.5f, -0.5f);
        Minecraft.getInstance().getItemRenderer().renderStatic((LivingEntity)player, flower, ItemDisplayContext.NONE, false, ms, buffers, player.level(), 0xF000F0, OverlayTexture.NO_OVERLAY, player.getId());
        ms.popPose();
    }
}

