/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.block_entity;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Random;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.common.block.block_entity.FloatingFlowerBlockEntity;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.xplat.BotaniaConfig;
import vazkii.botania.xplat.ClientXplatAbstractions;

public class FloatingFlowerBlockEntityRenderer
implements BlockEntityRenderer<FloatingFlowerBlockEntity> {
    public FloatingFlowerBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(@NotNull FloatingFlowerBlockEntity tile, float t, PoseStack ms, MultiBufferSource buffers, int light, int overlay) {
        FloatingFlowerBlockEntityRenderer.renderFloatingIsland(tile, t, ms, buffers, overlay);
    }

    public static void renderFloatingIsland(BlockEntity tile, float t, PoseStack ms, MultiBufferSource buffers, int overlay) {
        if (BotaniaConfig.client().staticFloaters()) {
            return;
        }
        ms.pushPose();
        double worldTime = (float)ClientTickHandler.ticksInGame + t;
        if (tile.getLevel() != null) {
            worldTime += (double)new Random(tile.getBlockPos().hashCode()).nextInt(1000);
        }
        ms.translate(0.5f, 0.0f, 0.5f);
        ms.mulPose(VecHelper.rotateY(-((float)worldTime * 0.5f)));
        ms.translate(-0.5, (double)((float)Math.sin(worldTime * (double)0.05f) * 0.1f), 0.5);
        ms.mulPose(VecHelper.rotateX(4.0f * (float)Math.sin(worldTime * (double)0.04f)));
        ms.mulPose(VecHelper.rotateY(90.0f));
        ClientXplatAbstractions.INSTANCE.tessellateBlock(tile.getLevel(), tile.getBlockState(), tile.getBlockPos(), ms, buffers, overlay);
        ms.popPose();
    }
}

