/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.handler;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.recipe.OrechidRecipe;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.xplat.XplatAbstractions;

public class OrechidManager
implements ResourceManagerReloadListener {
    private static final Map<RecipeType<? extends OrechidRecipe>, Map<BlockState, List<? extends OrechidRecipe>>> BY_TYPE = new IdentityHashMap<RecipeType<? extends OrechidRecipe>, Map<BlockState, List<? extends OrechidRecipe>>>();
    private static final Map<RecipeType<? extends OrechidRecipe>, Object2IntOpenHashMap<BlockState>> TOTAL_WEIGHTS_WITHOUT_POSITION = new IdentityHashMap<RecipeType<? extends OrechidRecipe>, Object2IntOpenHashMap<BlockState>>();

    public static void registerListener() {
        XplatAbstractions.INSTANCE.registerReloadListener(PackType.SERVER_DATA, ResourceLocationHelper.prefix("orechid"), (PreparableReloadListener)new OrechidManager());
    }

    public void onResourceManagerReload(@NotNull ResourceManager manager) {
        BY_TYPE.clear();
        TOTAL_WEIGHTS_WITHOUT_POSITION.clear();
    }

    public static <T extends OrechidRecipe> Collection<T> getMatchingRecipes(RecipeManager manager, RecipeType<T> type, BlockState state) {
        List list;
        Map byState = BY_TYPE.computeIfAbsent(type, t -> new IdentityHashMap());
        List result = list = byState.computeIfAbsent(state, s -> {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (OrechidRecipe recipe : manager.getAllRecipesFor(type)) {
                if (!recipe.getInput().test(state)) continue;
                builder.add((Object)recipe);
            }
            return builder.build();
        });
        return result;
    }

    public static int getTotalDisplayWeightAt(Level level, RecipeType<? extends OrechidRecipe> type, BlockState state, @Nullable BlockPos pos) {
        return pos == null ? OrechidManager.getCachedTotalDisplayWeightWithoutPosition(level, type, state) : OrechidManager.calculateTotalDisplayWeightAtPosition(level, type, state, pos);
    }

    private static int getCachedTotalDisplayWeightWithoutPosition(Level level, RecipeType<? extends OrechidRecipe> type, BlockState state) {
        Object2IntOpenHashMap byState = TOTAL_WEIGHTS_WITHOUT_POSITION.computeIfAbsent(type, t -> new Object2IntOpenHashMap());
        return byState.computeIfAbsent((Object)state, s -> OrechidManager.calculateTotalDisplayWeightAtPosition(level, type, state, null));
    }

    private static int calculateTotalDisplayWeightAtPosition(Level level, RecipeType<? extends OrechidRecipe> type, BlockState state, @Nullable BlockPos pos) {
        Collection<? extends OrechidRecipe> recipeList = OrechidManager.getMatchingRecipes(level.getRecipeManager(), type, state);
        if (recipeList.isEmpty()) {
            return 0;
        }
        ToIntFunction<OrechidRecipe> weightFunction = pos != null ? r -> r.getWeight(level, pos) : OrechidRecipe::getWeight;
        return recipeList.stream().mapToInt(weightFunction).sum();
    }
}

