/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.entity.BotaniaEntities;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class EnderAirBottleEntity
extends ThrowableProjectile
implements ItemSupplier {
    public static final int PARTICLE_COLOR = 8;
    private static final ResourceLocation GHAST_LOOT_TABLE = ResourceLocationHelper.prefix("ghast_ender_air_crying");

    public EnderAirBottleEntity(EntityType<EnderAirBottleEntity> type, Level world) {
        super(type, world);
    }

    public EnderAirBottleEntity(LivingEntity entity, Level world) {
        super(BotaniaEntities.ENDER_AIR_BOTTLE, entity, world);
    }

    public EnderAirBottleEntity(double x, double y, double z, Level world) {
        super(BotaniaEntities.ENDER_AIR_BOTTLE, x, y, z, world);
    }

    private void convertBlock(@NotNull BlockPos pos) {
        List<BlockPos> coordsList = this.getCoordsToPut(pos);
        this.level().levelEvent(2002, this.blockPosition(), 8);
        for (BlockPos coords : coordsList) {
            this.level().setBlockAndUpdate(coords, Blocks.END_STONE.defaultBlockState());
            if (!(Math.random() < 0.1)) continue;
            this.level().levelEvent(2001, coords, Block.getId((BlockState)Blocks.END_STONE.defaultBlockState()));
        }
    }

    protected void onHitBlock(@NotNull BlockHitResult result) {
        super.onHitBlock(result);
        if (this.level().isClientSide) {
            return;
        }
        this.convertBlock(result.getBlockPos());
        this.discard();
    }

    protected void onHitEntity(@NotNull EntityHitResult result) {
        super.onHitEntity(result);
        if (this.level().isClientSide) {
            return;
        }
        Entity entity = result.getEntity();
        if (entity.getType() == EntityType.GHAST && this.level().dimension() == Level.OVERWORLD) {
            this.level().levelEvent(2002, this.blockPosition(), 8);
            DamageSource source = entity.damageSources().thrown((Entity)this, this.getOwner());
            entity.hurt(source, 0.0f);
            Vec3 lookVec = entity.getLookAngle();
            Vec3 vec = new Vec3(lookVec.x(), 0.0, lookVec.z()).normalize();
            ((ServerLevel)this.level()).sendParticles((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, new ItemStack((ItemLike)Items.GHAST_TEAR)), entity.getX() + 2.3 * vec.x, entity.getY() + vec.y + 2.6, entity.getZ() + 2.3 * vec.z, 40, Math.abs(vec.z) + 0.15, 0.2, Math.abs(vec.x) + 0.15, 0.2);
            LootTable table = this.level().getServer().getLootData().getLootTable(GHAST_LOOT_TABLE);
            LootParams.Builder builder = new LootParams.Builder((ServerLevel)this.level());
            builder.withParameter(LootContextParams.THIS_ENTITY, (Object)entity);
            builder.withParameter(LootContextParams.ORIGIN, (Object)entity.position());
            builder.withParameter(LootContextParams.DAMAGE_SOURCE, (Object)source);
            LootParams context = builder.create(LootContextParamSets.ENTITY);
            for (ItemStack stack : table.getRandomItems(context)) {
                ItemEntity item = entity.spawnAtLocation(stack, 2.0f);
                item.setDeltaMovement(item.getDeltaMovement().add(vec.scale(0.4)));
            }
        } else {
            this.convertBlock(BlockPos.containing((Position)result.getLocation()));
        }
        this.discard();
    }

    private List<BlockPos> getCoordsToPut(BlockPos pos) {
        ArrayList<BlockPos> possibleCoords = new ArrayList<BlockPos>();
        int range = 4;
        int rangeY = 4;
        for (BlockPos bPos : BlockPos.betweenClosed((BlockPos)pos.offset(-range, -rangeY, -range), (BlockPos)pos.offset(range, rangeY, range))) {
            BlockState state = this.level().getBlockState(bPos);
            if (!state.is(BotaniaTags.Blocks.ENDER_AIR_CONVERTABLE)) continue;
            possibleCoords.add(bPos.immutable());
        }
        Collections.shuffle(possibleCoords);
        if (possibleCoords.size() > 64) {
            return possibleCoords.subList(0, 64);
        }
        return possibleCoords;
    }

    protected void defineSynchedData() {
    }

    @NotNull
    public ItemStack getItem() {
        return new ItemStack((ItemLike)BotaniaItems.enderAirBottle);
    }
}

