/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting;

import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.api.recipe.StateIngredient;

public class BlockStateIngredient
implements StateIngredient {
    private final Block block;

    public BlockStateIngredient(Block block) {
        this.block = block;
    }

    @Override
    public boolean test(BlockState blockState) {
        return this.block == blockState.getBlock();
    }

    @Override
    public BlockState pick(RandomSource random) {
        return this.block.defaultBlockState();
    }

    @Override
    public JsonObject serialize() {
        JsonObject object = new JsonObject();
        object.addProperty("type", "block");
        object.addProperty("block", BuiltInRegistries.BLOCK.getKey((Object)this.block).toString());
        return object;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeVarInt(1);
        buffer.writeVarInt(BuiltInRegistries.BLOCK.getId((Object)this.block));
    }

    @Override
    public List<ItemStack> getDisplayedStacks() {
        if (this.block.asItem() == Items.AIR) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new ItemStack((ItemLike)this.block));
    }

    @Override
    public List<BlockState> getDisplayed() {
        return Collections.singletonList(this.block.defaultBlockState());
    }

    public Block getBlock() {
        return this.block;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.block == ((BlockStateIngredient)o).block;
    }

    public int hashCode() {
        return this.block.hashCode();
    }

    public String toString() {
        return "BlockStateIngredient{" + this.block + "}";
    }
}

