/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.flower.generating;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import vazkii.botania.api.block_entity.GeneratingFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.xplat.XplatAbstractions;

public class EntropinnyumBlockEntity
extends GeneratingFlowerBlockEntity {
    private static final int RANGE = 12;
    private static final int EXPLODE_EFFECT_EVENT = 0;
    private static final int ANGRY_EFFECT_EVENT = 1;

    public EntropinnyumBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaFlowerBlocks.ENTROPINNYUM, pos, state);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (!this.getLevel().isClientSide && this.getMana() == 0) {
            List tnts = this.getLevel().getEntitiesOfClass(PrimedTnt.class, new AABB(this.getEffectivePos().offset(-12, -12, -12), this.getEffectivePos().offset(13, 13, 13)));
            for (PrimedTnt tnt : tnts) {
                FluidState fluid = this.getLevel().getFluidState(tnt.blockPosition());
                if (tnt.getFuse() != 1 || !tnt.isAlive() || !fluid.isEmpty()) continue;
                boolean unethical = XplatAbstractions.INSTANCE.ethicalComponent(tnt).isUnethical();
                tnt.playSound(unethical ? BotaniaSounds.entropinnyumAngry : BotaniaSounds.entropinnyumHappy, 1.0f, (1.0f + (this.getLevel().random.nextFloat() - this.getLevel().random.nextFloat()) * 0.2f) * 0.7f);
                tnt.discard();
                this.addMana(unethical ? 3 : this.getMaxMana());
                this.sync();
                this.getLevel().blockEvent(this.getBlockPos(), this.getBlockState().getBlock(), unethical ? 1 : 0, tnt.getId());
                break;
            }
        }
    }

    public boolean triggerEvent(int event, int param) {
        if (event == 0) {
            if (this.getLevel().isClientSide && this.getLevel().getEntity(param) instanceof PrimedTnt) {
                Entity e = this.getLevel().getEntity(param);
                for (int i = 0; i < 50; ++i) {
                    SparkleParticleData data = SparkleParticleData.sparkle((float)(Math.random() * (double)0.65f + 1.25), 1.0f, (float)Math.random() * 0.25f, (float)Math.random() * 0.25f, 12);
                    this.level.addParticle((ParticleOptions)data, e.getX() + Math.random() * 4.0 - 2.0, e.getY() + Math.random() * 4.0 - 2.0, e.getZ() + Math.random() * 4.0 - 2.0, 0.0, 0.0, 0.0);
                }
                this.getLevel().addParticle((ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, e.getX(), e.getY(), e.getZ(), 1.0, 0.0, 0.0);
            }
            return true;
        }
        if (event == 1) {
            if (this.getLevel().isClientSide && this.getLevel().getEntity(param) instanceof PrimedTnt) {
                Entity e = this.getLevel().getEntity(param);
                for (int i = 0; i < 50; ++i) {
                    this.level.addParticle((ParticleOptions)ParticleTypes.ANGRY_VILLAGER, e.getX() + Math.random() * 4.0 - 2.0, e.getY() + Math.random() * 4.0 - 2.0, e.getZ() + Math.random() * 4.0 - 2.0, 0.0, 0.0, 0.0);
                }
            }
            return true;
        }
        return super.triggerEvent(event, param);
    }

    @Override
    public int getColor() {
        return 0xCB0000;
    }

    @Override
    public int getMaxMana() {
        return 6500;
    }

    @Override
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square(this.getEffectivePos(), 12);
    }
}

