/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.flower.functional;

import java.util.Iterator;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.mixin.CreeperAccessor;
import vazkii.botania.mixin.MobAccessor;
import vazkii.botania.mixin.NearestAttackableTargetGoalAccessor;
import vazkii.botania.xplat.XplatAbstractions;

public class TigerseyeBlockEntity
extends FunctionalFlowerBlockEntity {
    private static final int RANGE = 10;
    private static final int RANGE_Y = 4;
    private static final int COST = 70;
    private static final int SUCCESS_EVENT = 0;

    public TigerseyeBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaFlowerBlocks.TIGERSEYE, pos, state);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (this.getLevel().isClientSide) {
            return;
        }
        for (Creeper entity : this.getLevel().getEntitiesOfClass(Creeper.class, new AABB(this.getEffectivePos().offset(-10, -4, -10), this.getEffectivePos().offset(11, 5, 11)))) {
            ((CreeperAccessor)entity).setCurrentFuseTime(2);
            entity.setTarget(null);
            if (this.getMana() < 70 || !TigerseyeBlockEntity.pacifyCreeper(entity)) continue;
            XplatAbstractions.INSTANCE.tigersEyeComponent(entity).setPacified();
            entity.playSound(BotaniaSounds.tigerseyePacify, 1.0f, (this.level.random.nextFloat() - this.level.random.nextFloat()) * 0.2f + 1.0f);
            this.level.blockEvent(this.getBlockPos(), this.getBlockState().getBlock(), 0, entity.getId());
            this.addMana(-70);
            this.sync();
        }
    }

    public static void pacifyAfterLoad(Entity entity, ServerLevel level) {
        Creeper creeper;
        if (entity instanceof Creeper && XplatAbstractions.INSTANCE.tigersEyeComponent(creeper = (Creeper)entity).isPacified()) {
            TigerseyeBlockEntity.pacifyCreeper(creeper);
        }
    }

    private static boolean pacifyCreeper(Creeper creeper) {
        boolean did = false;
        GoalSelector goalSelector = ((MobAccessor)creeper).getGoalSelector();
        Set goals = goalSelector.getAvailableGoals();
        for (WrappedGoal goal : goals) {
            Goal wrapped = goal.getGoal();
            if (!(wrapped instanceof CreeperAvoidPlayerGoal)) continue;
            CreeperAvoidPlayerGoal playerGoal = (CreeperAvoidPlayerGoal)wrapped;
            if (playerGoal.enabled) continue;
            playerGoal.enable();
            did = true;
            break;
        }
        GoalSelector targetSelector = ((MobAccessor)creeper).getTargetSelector();
        Iterator iterator = targetSelector.getAvailableGoals().iterator();
        while (iterator.hasNext()) {
            NearestAttackableTargetGoalAccessor targetGoal;
            WrappedGoal pg = (WrappedGoal)iterator.next();
            Goal goal = pg.getGoal();
            if (!(goal instanceof NearestAttackableTargetGoalAccessor) || (targetGoal = (NearestAttackableTargetGoalAccessor)goal).getTargetClass() != Player.class) continue;
            iterator.remove();
            did = true;
        }
        return did;
    }

    public boolean triggerEvent(int id, int payload) {
        if (id == 0) {
            Entity e;
            if (this.level.isClientSide && (e = this.level.getEntity(payload)) != null) {
                float r = (float)(this.getColor() >> 16 & 0xFF) / 255.0f;
                float g = (float)(this.getColor() >> 8 & 0xFF) / 255.0f;
                float b = (float)(this.getColor() & 0xFF) / 255.0f;
                SparkleParticleData data = SparkleParticleData.sparkle(this.level.random.nextFloat(), r, g, b, 10);
                for (int i = 0; i < 50; ++i) {
                    double x = e.getX() + this.level.random.nextDouble() - 0.5;
                    double y = e.getY() + (double)e.getBbHeight() * this.level.random.nextDouble();
                    double z = e.getZ() + this.level.random.nextDouble() - 0.5;
                    this.level.addParticle((ParticleOptions)data, x, y, z, 0.0, 0.0, 0.0);
                }
            }
            return true;
        }
        return super.triggerEvent(id, payload);
    }

    @Override
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square(this.getEffectivePos(), 10);
    }

    @Override
    public int getColor() {
        return 11642392;
    }

    @Override
    public int getMaxMana() {
        return 1000;
    }

    public static class CreeperAvoidPlayerGoal
    extends AvoidEntityGoal<Player> {
        private boolean enabled = false;

        public CreeperAvoidPlayerGoal(Creeper mob) {
            this(mob, 6.0f, 1.0, 1.2);
        }

        private CreeperAvoidPlayerGoal(Creeper mob, float maxDist, double walkSpeedModifier, double sprintSpeedModifier) {
            super((PathfinderMob)mob, Player.class, maxDist, walkSpeedModifier, sprintSpeedModifier);
        }

        public void enable() {
            this.enabled = true;
        }

        public boolean canUse() {
            return this.enabled && super.canUse();
        }
    }
}

