/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.flower.functional;

import com.mojang.datafixers.util.Pair;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.api.block_entity.SpecialFlowerBlockEntity;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.block.BotaniaFlowerBlocks;

public class BergamuteBlockEntity
extends SpecialFlowerBlockEntity {
    private static final int RANGE = 4;
    private static final Set<BergamuteBlockEntity> clientFlowers = Collections.newSetFromMap(new WeakHashMap());
    private static final Set<BergamuteBlockEntity> serverFlowers = Collections.newSetFromMap(new WeakHashMap());
    private boolean disabled = false;

    public BergamuteBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaFlowerBlocks.BERGAMUTE, pos, state);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        this.disabled = this.getLevel().hasNeighborSignal(this.getBlockPos());
        if (this.getLevel().isClientSide) {
            clientFlowers.add(this);
        } else {
            serverFlowers.add(this);
        }
    }

    public void setRemoved() {
        super.setRemoved();
        if (this.getLevel().isClientSide) {
            clientFlowers.remove(this);
        } else {
            serverFlowers.remove(this);
        }
    }

    public static Pair<Integer, BergamuteBlockEntity> getBergamutesNearby(Level level, double x, double y, double z, int maxCount) {
        int count = 0;
        BergamuteBlockEntity tile = null;
        for (BergamuteBlockEntity f : level.isClientSide ? clientFlowers : serverFlowers) {
            if (f.disabled || level != f.level || !(f.getEffectivePos().distToCenterSqr(x, y, z) <= 16.0)) continue;
            if (++count == 1) {
                tile = f;
            }
            if (count < maxCount) continue;
            break;
        }
        return Pair.of((Object)count, tile);
    }

    public static boolean isBergamuteNearby(Level level, double x, double y, double z) {
        return (Integer)BergamuteBlockEntity.getBergamutesNearby(level, x, y, z, 1).getFirst() > 0;
    }

    public static boolean isBergamuteOccludingVibration(Level level, Vec3 sourcePos, Vec3 destPos) {
        BlockPos sourceBlockPos = BlockPos.containing((Position)sourcePos);
        BlockPos destBlockPos = BlockPos.containing((Position)destPos);
        Vec3 sourceCenterPos = sourceBlockPos.getCenter();
        if (sourceBlockPos.equals((Object)destBlockPos)) {
            return BergamuteBlockEntity.isBergamuteNearby(level, sourceCenterPos.x, sourceCenterPos.y, sourceCenterPos.z);
        }
        Vec3 destCenterPos = destBlockPos.getCenter();
        Vec3 vibrationTravelVector = sourceCenterPos.vectorTo(destCenterPos);
        double vibrationTravelDist = vibrationTravelVector.length();
        Vec3 vibrationTravelDir = vibrationTravelVector.normalize();
        for (BergamuteBlockEntity f : level.isClientSide ? clientFlowers : serverFlowers) {
            Vec3 vecSourceToFlower;
            double travelPosition;
            Vec3 closestPos;
            Vec3 flowerPos;
            if (f.disabled || f.level != level || !((flowerPos = f.getEffectivePos().getCenter()).distanceToSqr(closestPos = sourceCenterPos.add(vibrationTravelDir.scale(travelPosition = Mth.clamp((double)vibrationTravelDir.dot(vecSourceToFlower = sourceCenterPos.vectorTo(flowerPos)), (double)0.0, (double)vibrationTravelDist)))) <= 16.0)) continue;
            return true;
        }
        return false;
    }

    public static void particle(BergamuteBlockEntity berg) {
        int color = 50943;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        SparkleParticleData data = SparkleParticleData.sparkle((float)Math.random(), red, green, blue, 5);
        berg.emitParticle(data, 0.3 + Math.random() * 0.5, 0.5 + Math.random() * 0.5, 0.3 + Math.random() * 0.5, 0.0, 0.0, 0.0);
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Circle(this.getEffectivePos(), 4.0);
    }
}

