/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.block_entity.corporea;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.corporea.CorporeaHelper;
import vazkii.botania.api.corporea.CorporeaRequestMatcher;
import vazkii.botania.api.corporea.CorporeaRequestor;
import vazkii.botania.api.corporea.CorporeaSpark;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.corporea.BaseCorporeaBlockEntity;
import vazkii.botania.common.helper.FilterHelper;
import vazkii.botania.common.helper.InventoryHelper;
import vazkii.botania.xplat.XplatAbstractions;

public class CorporeaFunnelBlockEntity
extends BaseCorporeaBlockEntity
implements CorporeaRequestor {
    private static final int[] ROTATION_TO_STACK_SIZE = new int[]{1, 2, 4, 8, 16, 32, 48, 64};

    public CorporeaFunnelBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaBlockEntities.CORPOREA_FUNNEL, pos, state);
    }

    public void doRequest() {
        ItemStack stack;
        WeightedRandomList<FilterHelper.WeightedItemStack> filter;
        CorporeaSpark spark = this.getSpark();
        if (spark != null && spark.getMaster() != null && !(filter = this.getFilter()).isEmpty() && !(stack = filter.getRandom(this.level.random).map(FilterHelper.WeightedItemStack::stack).orElse(ItemStack.EMPTY)).isEmpty()) {
            CorporeaRequestMatcher matcher = CorporeaHelper.instance().createMatcher(stack, true);
            this.doCorporeaRequest(matcher, stack.getCount(), spark, null);
        }
    }

    public WeightedRandomList<FilterHelper.WeightedItemStack> getFilter() {
        ArrayList filter = new ArrayList();
        for (Direction dir : Direction.values()) {
            List frames = this.level.getEntitiesOfClass(ItemFrame.class, new AABB(this.worldPosition.relative(dir), this.worldPosition.relative(dir).offset(1, 1, 1)));
            for (ItemFrame frame : frames) {
                List<ItemStack> filterStacks;
                Direction orientation = frame.getDirection();
                if (orientation != dir || (filterStacks = FilterHelper.getFilterItems(frame)).isEmpty()) continue;
                int stackSize = ROTATION_TO_STACK_SIZE[frame.getRotation()];
                filterStacks.stream().map(s -> FilterHelper.WeightedItemStack.of(s.copyWithCount(stackSize), s.getCount())).forEach(filter::add);
            }
        }
        return WeightedRandomList.create(filter);
    }

    @Override
    public void doCorporeaRequest(CorporeaRequestMatcher request, int count, CorporeaSpark spark, @Nullable LivingEntity entity) {
        BlockPos invPos = this.getInvPos();
        List<ItemStack> stacks = CorporeaHelper.instance().requestItem(request, count, spark, entity, true).stacks();
        spark.onItemsRequested(stacks);
        for (ItemStack reqStack : stacks) {
            if (invPos != null && XplatAbstractions.INSTANCE.insertToInventory(this.level, invPos, Direction.UP, reqStack, true).isEmpty()) {
                InventoryHelper.checkEmpty(XplatAbstractions.INSTANCE.insertToInventory(this.level, invPos, Direction.UP, reqStack, false));
                continue;
            }
            ItemEntity item = new ItemEntity(this.level, spark.entity().getX(), spark.entity().getY(), spark.entity().getZ(), reqStack);
            this.level.addFreshEntity((Entity)item);
        }
    }

    @Nullable
    private BlockPos getInvPos() {
        BlockPos downOne = this.worldPosition.below();
        if (XplatAbstractions.INSTANCE.hasInventory(this.level, downOne, Direction.UP)) {
            return downOne;
        }
        BlockPos downTwo = this.worldPosition.below(2);
        if (XplatAbstractions.INSTANCE.hasInventory(this.level, downTwo, Direction.UP)) {
            return downTwo;
        }
        return null;
    }
}

