/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.emi;

import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.TextWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.recipe.OrechidRecipe;
import vazkii.botania.client.integration.emi.BotaniaEmiRecipe;
import vazkii.botania.client.integration.emi.PureDaisyEmiRecipe;
import vazkii.botania.client.integration.shared.OrechidUIHelper;

public class OrechidEmiRecipe
extends BotaniaEmiRecipe {
    private final EmiIngredient orechid;
    protected final OrechidRecipe recipe;

    public OrechidEmiRecipe(EmiRecipeCategory category, OrechidRecipe recipe, EmiIngredient orechid) {
        super(category, recipe);
        try {
            this.input = recipe.getInput().getDisplayed().stream().map(s -> EmiIngredient.of((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{s.getBlock()}), (long)1L)).toList();
            this.output = recipe.getOutput().getDisplayed().stream().map(s -> EmiStack.of((ItemStack)new ItemStack((ItemLike)s.getBlock()))).toList();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        this.orechid = orechid;
        this.recipe = recipe;
    }

    public int getDisplayHeight() {
        return 44;
    }

    public int getDisplayWidth() {
        return 96;
    }

    public boolean supportsRecipeTree() {
        return false;
    }

    public void addWidgets(WidgetHolder widgets) {
        PureDaisyEmiRecipe.addPureDaisyWidgets(widgets, this, (EmiIngredient)this.input.get(0), this.orechid, (EmiStack)this.output.get(0));
        final Double chance = this.getChance(this.recipe);
        if (chance != null) {
            Component chanceComponent = OrechidUIHelper.getPercentageComponent(chance);
            widgets.add((Widget)new TextWidget(chanceComponent.getVisualOrderText(), 90, 3, 0x555555, false){

                public List<ClientTooltipComponent> getTooltip(int mouseX, int mouseY) {
                    return OrechidEmiRecipe.this.getChanceTooltipComponents(chance).map(Component::getVisualOrderText).map(ClientTooltipComponent::create).toList();
                }
            }.horizontalAlign(TextWidget.Alignment.END));
        }
    }

    @NotNull
    protected Stream<Component> getChanceTooltipComponents(double chance) {
        IntIntPair ratio = OrechidUIHelper.getRatioForChance(chance);
        return Stream.of(OrechidUIHelper.getRatioTooltipComponent(ratio));
    }

    @Nullable
    protected Double getChance(@NotNull OrechidRecipe recipe) {
        return OrechidUIHelper.getChance(recipe, null);
    }

    public int getWeight() {
        return this.recipe.getWeight();
    }
}

