/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.test.block;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.SeaPickleBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import vazkii.botania.test.TestingUtil;

public class RannuncarpusTest {
    private static final String TEMPLATE = "botania:block/rannuncarpus";
    private static final String TEMPLATE_CANDLES = "botania:block/rannuncarpus_candles";
    private static final BlockPos FLOWER_POS = new BlockPos(2, 3, 2);
    private static final BlockPos FILTER_POS = FLOWER_POS.below();
    private static final BlockPos EXPECTED_PLACE_POS = new BlockPos(3, 2, 2);
    private static final BlockPos FILTERED_POS = EXPECTED_PLACE_POS.below();
    private static final BlockPos MAGENTA_CANDLE_POS = new BlockPos(3, 3, 3);
    private static final BlockPos EXPECTED_PLACE_POS1 = new BlockPos(1, 3, 3);
    private static final BlockPos EXPECTED_PLACE_POS2 = new BlockPos(3, 3, 1);
    private static final BlockPos SEA_PICKLE_POS = new BlockPos(1, 2, 1);
    private static final BlockPos FLOATING_YELLOW_CANDLE_POS = new BlockPos(1, 5, 2);
    private static final int MULTI_PLACEMENT_TIMEOUT_TICKS = 240;

    @GameTest(template="botania:block/rannuncarpus", batch="rannuncarpus1")
    public void testDestinationFilterPositive(GameTestHelper helper) {
        helper.startSequence().thenExecute(() -> {
            helper.killAllEntities();
            helper.spawnItem(Blocks.STONE.asItem(), (float)FLOWER_POS.getX(), (float)(FLOWER_POS.getY() + 1), (float)FLOWER_POS.getZ());
        }).thenWaitUntil(() -> helper.assertBlockPresent(Blocks.STONE, EXPECTED_PLACE_POS)).thenSucceed();
    }

    @GameTest(template="botania:block/rannuncarpus", batch="rannuncarpus2")
    public void testDestinationFilterNegative(GameTestHelper helper) {
        helper.startSequence().thenExecute(() -> {
            helper.killAllEntities();
            helper.setBlock(FILTERED_POS, Blocks.POLISHED_ANDESITE);
            helper.spawnItem(Blocks.STONE.asItem(), (float)FLOWER_POS.getX(), (float)(FLOWER_POS.getY() + 1), (float)FLOWER_POS.getZ());
        }).thenExecuteFor(61, () -> helper.assertBlockNotPresent(Blocks.STONE, EXPECTED_PLACE_POS)).thenSucceed();
    }

    @GameTest(template="botania:block/rannuncarpus")
    public void testPickupFilterPositive(GameTestHelper helper) {
        helper.startSequence().thenExecute(() -> {
            ItemFrame frame = RannuncarpusTest.getItemFrame(helper);
            frame.setItem(new ItemStack((ItemLike)Blocks.STONE));
            helper.spawnItem(Blocks.STONE.asItem(), (float)FLOWER_POS.getX(), (float)(FLOWER_POS.getY() + 1), (float)FLOWER_POS.getZ());
        }).thenWaitUntil(() -> helper.assertBlockPresent(Blocks.STONE, EXPECTED_PLACE_POS)).thenSucceed();
    }

    @GameTest(template="botania:block/rannuncarpus")
    public void testPickupFilterNegative(GameTestHelper helper) {
        helper.startSequence().thenExecute(() -> {
            ItemFrame frame = RannuncarpusTest.getItemFrame(helper);
            frame.setItem(new ItemStack((ItemLike)Blocks.COBBLESTONE));
            helper.spawnItem(Blocks.STONE.asItem(), (float)FLOWER_POS.getX(), (float)(FLOWER_POS.getY() + 1), (float)FLOWER_POS.getZ());
        }).thenExecuteFor(61, () -> helper.assertBlockNotPresent(Blocks.STONE, EXPECTED_PLACE_POS)).thenSucceed();
    }

    @GameTest(template="botania:block/rannuncarpus_candles", timeoutTicks=240, batch="rannuncarpus3")
    public void testMultiplePlacements(GameTestHelper helper) {
        ItemEntity yellowCandles = helper.spawnItem(Blocks.YELLOW_CANDLE.asItem(), (float)FLOWER_POS.getX(), (float)(FLOWER_POS.getY() + 1), (float)FLOWER_POS.getZ());
        helper.startSequence().thenExecute(() -> {
            ItemStack stack = yellowCandles.getItem();
            stack.setCount(10);
            yellowCandles.setItem(stack);
        }).thenWaitUntil(() -> {
            helper.assertBlockPresent(Blocks.YELLOW_CANDLE, EXPECTED_PLACE_POS1);
            helper.assertBlockPresent(Blocks.YELLOW_CANDLE, EXPECTED_PLACE_POS2);
            helper.assertBlockProperty(EXPECTED_PLACE_POS1, (Property)CandleBlock.CANDLES, (Comparable)Integer.valueOf(4));
            helper.assertBlockProperty(EXPECTED_PLACE_POS2, (Property)CandleBlock.CANDLES, (Comparable)Integer.valueOf(4));
        }).thenExecuteAfter(11, () -> {
            helper.assertBlockProperty(FLOATING_YELLOW_CANDLE_POS, (Property)CandleBlock.CANDLES, (Comparable)Integer.valueOf(1));
            if (yellowCandles.getItem().getCount() < 2) {
                helper.fail("Too few yellow candles left over", (Entity)yellowCandles);
            }
            helper.killAllEntities();
        }).thenExecute(() -> {
            helper.spawnItem(Blocks.MAGENTA_CANDLE.asItem(), (float)FLOWER_POS.getX(), (float)(FLOWER_POS.getY() + 1), (float)FLOWER_POS.getZ());
            helper.spawnItem(Blocks.SEA_PICKLE.asItem(), (float)FLOWER_POS.getX(), (float)(FLOWER_POS.getY() + 1), (float)FLOWER_POS.getZ());
        }).thenWaitUntil(() -> {
            helper.assertBlockProperty(MAGENTA_CANDLE_POS, (Property)CandleBlock.CANDLES, (Comparable)Integer.valueOf(2));
            helper.assertBlockProperty(SEA_PICKLE_POS, (Property)SeaPickleBlock.PICKLES, (Comparable)Integer.valueOf(2));
        }).thenExecute(() -> {
            helper.assertBlockProperty(MAGENTA_CANDLE_POS, (Property)CandleBlock.LIT, (Comparable)Boolean.valueOf(true));
            helper.assertBlockProperty(SEA_PICKLE_POS, (Property)SeaPickleBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true));
        }).thenSucceed();
    }

    @GameTest(template="botania:block/rannuncarpus", timeoutTicks=190)
    public void testMultiplePlacementsPrefersEmptySpots(GameTestHelper helper) {
        helper.setBlock(FILTER_POS, Blocks.POLISHED_ANDESITE);
        helper.setBlock(FILTERED_POS, Blocks.POLISHED_ANDESITE);
        for (BlockPos pos : BlockPos.betweenClosed((int)0, (int)2, (int)0, (int)4, (int)2, (int)4)) {
            if ((pos.getX() + pos.getZ()) % 2 != 1) continue;
            helper.setBlock(pos, Blocks.SEA_PICKLE);
        }
        ItemEntity seaPickles = helper.spawnItem(Blocks.SEA_PICKLE.asItem(), (float)FLOWER_POS.getX(), (float)(FLOWER_POS.getY() + 1), (float)FLOWER_POS.getZ());
        ItemStack stack = seaPickles.getItem();
        stack.setCount(12);
        seaPickles.setItem(stack);
        helper.startSequence().thenExecuteAfter(181, () -> {
            for (BlockPos pos : BlockPos.betweenClosed((int)1, (int)2, (int)1, (int)4, (int)2, (int)4)) {
                if (pos.equals((Object)FILTER_POS)) continue;
                helper.assertBlockPresent(Blocks.SEA_PICKLE, pos);
                helper.assertBlockProperty(pos, (Property)SeaPickleBlock.PICKLES, (Comparable)Integer.valueOf(1));
            }
            if (!stack.isEmpty()) {
                helper.fail("Not all items used", (Entity)seaPickles);
            }
        }).thenSucceed();
    }

    private static ItemFrame getItemFrame(GameTestHelper helper) {
        AABB bounds = new AABB(helper.absolutePos(FLOWER_POS));
        List list = helper.getLevel().getEntitiesOfClass(ItemFrame.class, bounds);
        TestingUtil.assertThat(list.size() == 1, () -> "Number of item frames wasn't 1");
        return (ItemFrame)list.get(0);
    }
}

