/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.rod;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.block.Avatar;
import vazkii.botania.api.item.AvatarWieldable;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.entity.BotaniaEntities;
import vazkii.botania.common.entity.MagicMissileEntity;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.xplat.XplatAbstractions;

public class UnstableReservoirRodItem
extends Item {
    private static final ResourceLocation avatarOverlay = new ResourceLocation("botania:textures/model/avatar_missile.png");
    private static final int COST_PER = 120;
    private static final int COST_AVATAR = 40;

    public UnstableReservoirRodItem(Item.Properties props) {
        super(props);
    }

    @NotNull
    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int getUseDuration(ItemStack stack) {
        return 72000;
    }

    public void onUseTick(Level world, LivingEntity living, ItemStack stack, int count) {
        if (!(living instanceof Player)) {
            return;
        }
        Player player = (Player)living;
        if (count != this.getUseDuration(stack) && count % (ManaItemHandler.instance().hasProficiency(player, stack) ? 1 : 2) == 0 && ManaItemHandler.instance().requestManaExactForTool(stack, player, 120, false)) {
            if (!world.isClientSide && UnstableReservoirRodItem.spawnMissile(world, (LivingEntity)player, player.getX() + (Math.random() - 0.05), player.getY() + 2.4 + (Math.random() - 0.05), player.getZ() + (Math.random() - 0.05))) {
                ManaItemHandler.instance().requestManaExactForTool(stack, player, 120, true);
            }
            SparkleParticleData data = SparkleParticleData.sparkle(6.0f, 1.0f, 0.4f, 1.0f, 6);
            world.addParticle((ParticleOptions)data, player.getX(), player.getY() + 2.4, player.getZ(), 0.0, 0.0, 0.0);
        }
    }

    public static boolean spawnMissile(Level world, LivingEntity thrower, double x, double y, double z) {
        MagicMissileEntity missile = thrower != null ? new MagicMissileEntity(thrower, false) : (MagicMissileEntity)BotaniaEntities.MAGIC_MISSILE.create(world);
        missile.setPos(x, y, z);
        if (missile.findTarget()) {
            if (!world.isClientSide) {
                missile.playSound(world.random.nextInt(100) == 0 ? BotaniaSounds.missileFunny : BotaniaSounds.missile, 1.0f, 0.8f + (float)Math.random() * 0.2f);
                world.addFreshEntity((Entity)missile);
            }
            return true;
        }
        return false;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level world, Player player, @NotNull InteractionHand hand) {
        return ItemUtils.startUsingInstantly((Level)world, (Player)player, (InteractionHand)hand);
    }

    public static class AvatarBehavior
    implements AvatarWieldable {
        @Override
        public void onAvatarUpdate(Avatar tile) {
            BlockEntity te = (BlockEntity)tile;
            Level world = te.getLevel();
            BlockPos pos = te.getBlockPos();
            ManaReceiver receiver = XplatAbstractions.INSTANCE.findManaReceiver(world, te.getBlockPos(), te.getBlockState(), te, null);
            if (receiver != null && receiver.getCurrentMana() >= 40 && tile.getElapsedFunctionalTicks() % 3 == 0 && tile.isEnabled() && UnstableReservoirRodItem.spawnMissile(world, null, (double)pos.getX() + 0.5 + (Math.random() - 0.05), (double)pos.getY() + 2.5 + (Math.random() - 0.05), (double)pos.getZ() + (Math.random() - 0.05))) {
                if (!world.isClientSide) {
                    receiver.receiveMana(-40);
                }
                SparkleParticleData data = SparkleParticleData.sparkle(6.0f, 1.0f, 0.4f, 1.0f, 6);
                world.addParticle((ParticleOptions)data, (double)pos.getX() + 0.5, (double)pos.getY() + 2.5, (double)pos.getZ() + 0.5, 0.0, 0.0, 0.0);
            }
        }

        @Override
        public ResourceLocation getOverlayResource(Avatar tile) {
            return avatarOverlay;
        }
    }
}

