/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.lens;

import java.util.Iterator;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.common.item.lens.Lens;
import vazkii.botania.xplat.XplatAbstractions;

public class MagnetizingLens
extends Lens {
    @Override
    public void updateBurst(ManaBurst burst, ItemStack stack) {
        ThrowableProjectile entity = burst.entity();
        BlockPos basePos = entity.blockPosition();
        boolean magnetized = burst.getMagnetizedPos() != null;
        int range = 3;
        BlockPos source = burst.getBurstSourceBlockPos();
        boolean sourceless = source.equals((Object)ManaBurst.NO_SOURCE);
        Predicate<BlockPos> predicate = arg_0 -> MagnetizingLens.lambda$updateBurst$0((Entity)entity, sourceless, source, arg_0);
        BlockPos target = null;
        if (magnetized && !predicate.test(target = burst.getMagnetizedPos())) {
            target = null;
            burst.setMagnetizePos(null);
            magnetized = false;
        }
        if (!magnetized) {
            BlockPos pos;
            Iterator iterator = BlockPos.betweenClosed((BlockPos)basePos.offset(-range, -range, -range), (BlockPos)basePos.offset(range, range, range)).iterator();
            while (iterator.hasNext() && !predicate.test(target = (pos = (BlockPos)iterator.next()))) {
                target = null;
            }
        }
        if (target == null) {
            return;
        }
        Vec3 burstVec = entity.position();
        Vec3 tileVec = Vec3.atCenterOf((Vec3i)target).add(0.0, -0.1, 0.0);
        Vec3 motionVec = entity.getDeltaMovement();
        Vec3 normalMotionVec = motionVec.normalize();
        Vec3 magnetVec = tileVec.subtract(burstVec).normalize();
        Vec3 differenceVec = normalMotionVec.subtract(magnetVec).scale(motionVec.length() * 0.1);
        Vec3 finalMotionVec = motionVec.subtract(differenceVec);
        if (!magnetized) {
            finalMotionVec = finalMotionVec.scale(0.75);
            burst.setMagnetizePos(target.immutable());
        }
        entity.setDeltaMovement(finalMotionVec);
    }

    private static /* synthetic */ boolean lambda$updateBurst$0(Entity entity, boolean sourceless, BlockPos source, BlockPos pos) {
        ManaReceiver receiver = XplatAbstractions.INSTANCE.findManaReceiver(entity.level(), pos, null);
        return receiver != null && (sourceless || pos.distSqr((Vec3i)source) > 9.0) && receiver.canReceiveManaFromBursts() && !receiver.isFull();
    }
}

