/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.tool;

import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.common.item.equipment.tool.manasteel.ManasteelPickaxeItem;
import vazkii.botania.xplat.XplatAbstractions;

public class VitreousPickaxeItem
extends ManasteelPickaxeItem {
    private static final String TAG_SILK_HACK = "botania:silk_hack";
    private static final int MANA_PER_DAMAGE = 160;
    private static final Tier MATERIAL = new Tier(){

        public int getUses() {
            return 125;
        }

        public float getSpeed() {
            return 4.8f;
        }

        public float getAttackDamageBonus() {
            return 0.0f;
        }

        public int getLevel() {
            return 0;
        }

        public int getEnchantmentValue() {
            return 10;
        }

        public Ingredient getRepairIngredient() {
            return Ingredient.of((ItemLike[])new ItemLike[]{Blocks.GLASS});
        }
    };

    public VitreousPickaxeItem(Item.Properties props) {
        super(MATERIAL, props, -1.0f);
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, Player player) {
        boolean hasSilk;
        BlockState state = player.level().getBlockState(pos);
        boolean bl = hasSilk = EnchantmentHelper.getItemEnchantmentLevel((Enchantment)Enchantments.SILK_TOUCH, (ItemStack)itemstack) > 0;
        if (hasSilk || !this.isGlass(state)) {
            return false;
        }
        itemstack.enchant(Enchantments.SILK_TOUCH, 1);
        itemstack.getTag().putBoolean(TAG_SILK_HACK, true);
        return false;
    }

    @Override
    public void inventoryTick(ItemStack stack, Level world, Entity player, int slot, boolean selected) {
        super.inventoryTick(stack, world, player, slot, selected);
        if (stack.getOrCreateTag().getBoolean(TAG_SILK_HACK)) {
            stack.getTag().remove(TAG_SILK_HACK);
            Map ench = EnchantmentHelper.deserializeEnchantments((ListTag)stack.getEnchantmentTags());
            ench.remove(Enchantments.SILK_TOUCH);
            EnchantmentHelper.setEnchantments((Map)ench, (ItemStack)stack);
        }
    }

    private boolean isGlass(BlockState state) {
        return XplatAbstractions.INSTANCE.isInGlassTag(state);
    }

    @Override
    public int getManaPerDamage() {
        return 160;
    }

    @Override
    public int getSortingPriority(ItemStack stack, BlockState state) {
        return this.isGlass(state) ? Integer.MAX_VALUE : 0;
    }
}

