/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.handler;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.stream.StreamSupport;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.common.lib.LibBlockNames;

public class ContributorList {
    private static final ImmutableMap<String, String> LEGACY_FLOWER_NAMES = ImmutableMap.builder().put((Object)"daybloom", (Object)"daybloom_motif").put((Object)"nightshade", (Object)"nightshade_motif").put((Object)"puredaisy", (Object)LibBlockNames.SUBTILE_PUREDAISY.getPath()).put((Object)"fallenkanade", (Object)LibBlockNames.SUBTILE_FALLEN_KANADE.getPath()).put((Object)"heiseidream", (Object)LibBlockNames.SUBTILE_HEISEI_DREAM.getPath()).put((Object)"arcanerose", (Object)LibBlockNames.SUBTILE_ARCANE_ROSE.getPath()).put((Object)"jadedamaranthus", (Object)LibBlockNames.SUBTILE_JADED_AMARANTHUS.getPath()).put((Object)"orechidignem", (Object)LibBlockNames.SUBTILE_ORECHID_IGNEM.getPath()).build();
    private static volatile Map<String, ItemStack> flowerMap = Collections.emptyMap();
    private static boolean startedLoading = false;
    public static final String TAG_HEADFLOWER = "botania:headflower";

    public static void firstStart() {
        if (!startedLoading) {
            Thread thread = new Thread(ContributorList::fetch);
            thread.setName("Botania Contributor Fanciness Thread");
            thread.setDaemon(true);
            thread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(BotaniaAPI.LOGGER));
            thread.start();
            startedLoading = true;
        }
    }

    public static ItemStack getFlower(String name) {
        return flowerMap.getOrDefault(name, ItemStack.EMPTY);
    }

    public static boolean hasFlower(String name) {
        return flowerMap.containsKey(name);
    }

    private static void load(Properties props) {
        HashMap<String, ItemStack> m = new HashMap<String, ItemStack>();
        HashMap<Item, ItemStack> cachedStacks = new HashMap<Item, ItemStack>();
        for (String key : props.stringPropertyNames()) {
            ItemStack stack;
            String value = props.getProperty(key);
            try {
                int i = Integer.parseInt(value);
                if (i < 0 || i >= 16) {
                    throw new NumberFormatException();
                }
                stack = cachedStacks.computeIfAbsent(BotaniaBlocks.getFlower(DyeColor.byId((int)i)).asItem(), ContributorList::configureStack);
            }
            catch (NumberFormatException e) {
                String rawName = value.toLowerCase(Locale.ROOT);
                String flowerName = (String)LEGACY_FLOWER_NAMES.getOrDefault((Object)rawName, (Object)rawName);
                Item item = StreamSupport.stream(BuiltInRegistries.ITEM.getTagOrEmpty(BotaniaTags.Items.CONTRIBUTOR_HEADFLOWERS).spliterator(), false).filter(h -> h.is(resKey -> resKey.location().getPath().equals(flowerName))).findFirst().map(Holder::value).orElse(Items.POPPY);
                stack = cachedStacks.computeIfAbsent(item, ContributorList::configureStack);
            }
            m.put(key, stack);
        }
        flowerMap = m;
    }

    private static ItemStack configureStack(Item item) {
        ItemStack stack = new ItemStack((ItemLike)item);
        HashMap<Enchantment, Integer> ench = new HashMap<Enchantment, Integer>();
        ench.put(Enchantments.UNBREAKING, 1);
        BuiltInRegistries.ENCHANTMENT.getOptional(new ResourceLocation("charm", "tinted")).ifPresent(e -> ench.put((Enchantment)e, 1));
        EnchantmentHelper.setEnchantments(ench, (ItemStack)stack);
        stack.getTag().putBoolean(TAG_HEADFLOWER, true);
        stack.getTag().putString("charm_glint", DyeColor.YELLOW.getSerializedName());
        return stack;
    }

    private static void fetch() {
        InputStream stream;
        block4: {
            try {
                URL url = new URL("https://raw.githubusercontent.com/Vazkii/Botania/master/contributors.properties");
                stream = url.openStream();
            }
            catch (IOException e) {
                BotaniaAPI.LOGGER.info("Could not load live contributors list. Either you're offline or GitHub is down. Loading bundled copy.");
                stream = ContributorList.class.getClassLoader().getResourceAsStream("contributors.properties");
                if (stream != null) break block4;
                BotaniaAPI.LOGGER.info("Could not load bundled contributors list, somehow.");
                return;
            }
        }
        try {
            Properties props = new Properties();
            props.load(new InputStreamReader(stream, StandardCharsets.UTF_8));
            ContributorList.load(props);
            stream.close();
        }
        catch (IOException e) {
            BotaniaAPI.LOGGER.info("Error while reading contributors list.");
        }
    }
}

