/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.recipe.TerrestrialAgglomerationRecipe;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.crafting.recipe.RecipeUtils;

public class RecipeTerraPlate
implements TerrestrialAgglomerationRecipe {
    private final ResourceLocation id;
    private final int mana;
    private final NonNullList<Ingredient> inputs;
    private final ItemStack output;

    public RecipeTerraPlate(ResourceLocation id, int mana, NonNullList<Ingredient> inputs, ItemStack output) {
        this.id = id;
        this.mana = mana;
        this.inputs = inputs;
        this.output = output;
    }

    @Override
    public int getMana() {
        return this.mana;
    }

    public boolean matches(Container inv, @NotNull Level world) {
        int nonEmptySlots = 0;
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            if (inv.getItem(i).isEmpty()) continue;
            if (inv.getItem(i).getCount() > 1) {
                return false;
            }
            ++nonEmptySlots;
        }
        IntOpenHashSet usedSlots = new IntOpenHashSet(inv.getContainerSize());
        return RecipeUtils.matches(this.inputs, inv, (IntSet)usedSlots) && usedSlots.size() == nonEmptySlots;
    }

    @NotNull
    public ItemStack assemble(@NotNull Container inv, @NotNull RegistryAccess registries) {
        return this.output.copy();
    }

    @NotNull
    public ItemStack getResultItem(@NotNull RegistryAccess registries) {
        return this.output;
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        return this.inputs;
    }

    @NotNull
    public ResourceLocation getId() {
        return this.id;
    }

    @NotNull
    public RecipeSerializer<RecipeTerraPlate> getSerializer() {
        return BotaniaRecipeTypes.TERRA_PLATE_SERIALIZER;
    }

    public static class Serializer
    implements RecipeSerializer<RecipeTerraPlate> {
        @NotNull
        public RecipeTerraPlate fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
            int mana = GsonHelper.getAsInt((JsonObject)json, (String)"mana");
            JsonArray ingrs = GsonHelper.getAsJsonArray((JsonObject)json, (String)"ingredients");
            Object[] ingredients = new Ingredient[ingrs.size()];
            for (int i = 0; i < ingrs.size(); ++i) {
                ingredients[i] = Ingredient.fromJson((JsonElement)ingrs.get(i));
            }
            ItemStack output = ShapedRecipe.itemStackFromJson((JsonObject)GsonHelper.getAsJsonObject((JsonObject)json, (String)"result"));
            return new RecipeTerraPlate(recipeId, mana, (NonNullList<Ingredient>)NonNullList.of((Object)Ingredient.EMPTY, (Object[])ingredients), output);
        }

        public RecipeTerraPlate fromNetwork(@NotNull ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int mana = buffer.readVarInt();
            Object[] ingredients = new Ingredient[buffer.readVarInt()];
            for (int i = 0; i < ingredients.length; ++i) {
                ingredients[i] = Ingredient.fromNetwork((FriendlyByteBuf)buffer);
            }
            ItemStack output = buffer.readItem();
            return new RecipeTerraPlate(recipeId, mana, (NonNullList<Ingredient>)NonNullList.of((Object)Ingredient.EMPTY, (Object[])ingredients), output);
        }

        public void toNetwork(FriendlyByteBuf buffer, RecipeTerraPlate recipe) {
            buffer.writeVarInt(recipe.mana);
            buffer.writeVarInt(recipe.getIngredients().size());
            for (Ingredient ingr : recipe.getIngredients()) {
                ingr.toNetwork(buffer);
            }
            buffer.writeItem(recipe.output);
        }
    }
}

