/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.api.brew.BrewContainer;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;

public class BotanicalBreweryRecipe
implements vazkii.botania.api.recipe.BotanicalBreweryRecipe {
    private final ResourceLocation id;
    private final Brew brew;
    private final NonNullList<Ingredient> inputs;

    public BotanicalBreweryRecipe(ResourceLocation id, Brew brew, Ingredient ... inputs) {
        this.id = id;
        this.brew = brew;
        this.inputs = NonNullList.of((Object)Ingredient.EMPTY, (Object[])inputs);
    }

    public boolean matches(Container inv, @NotNull Level world) {
        ItemStack stack;
        ArrayList<Ingredient> inputsMissing = new ArrayList<Ingredient>((Collection<Ingredient>)this.inputs);
        for (int i = 0; i < inv.getContainerSize() && !(stack = inv.getItem(i)).isEmpty(); ++i) {
            if (stack.getItem() instanceof BrewContainer) continue;
            boolean matchedOne = false;
            Iterator iter = inputsMissing.iterator();
            while (iter.hasNext()) {
                Ingredient input = (Ingredient)iter.next();
                if (!input.test(stack)) continue;
                iter.remove();
                matchedOne = true;
                break;
            }
            if (matchedOne) continue;
            return false;
        }
        return inputsMissing.isEmpty();
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        return this.inputs;
    }

    @NotNull
    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)BotaniaBlocks.brewery);
    }

    @NotNull
    public ResourceLocation getId() {
        return this.id;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return BotaniaRecipeTypes.BREW_SERIALIZER;
    }

    @Override
    public Brew getBrew() {
        return this.brew;
    }

    @Override
    public int getManaUsage() {
        return this.brew.getManaCost();
    }

    @Override
    public ItemStack getOutput(ItemStack stack) {
        Item item;
        if (stack.isEmpty() || !((item = stack.getItem()) instanceof BrewContainer)) {
            return new ItemStack((ItemLike)Items.GLASS_BOTTLE);
        }
        BrewContainer container = (BrewContainer)item;
        return container.getItemForBrew(this.brew, stack);
    }

    public int hashCode() {
        return 31 * this.brew.hashCode() ^ this.inputs.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof BotanicalBreweryRecipe)) return false;
        BotanicalBreweryRecipe brewRecipe = (BotanicalBreweryRecipe)o;
        if (this.brew != brewRecipe.brew) return false;
        if (!this.inputs.equals(brewRecipe.inputs)) return false;
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<BotanicalBreweryRecipe> {
        @NotNull
        public BotanicalBreweryRecipe fromJson(@NotNull ResourceLocation id, @NotNull JsonObject json) {
            String brewStr = GsonHelper.getAsString((JsonObject)json, (String)"brew");
            ResourceLocation brewId = ResourceLocation.tryParse((String)brewStr);
            Brew brew = (Brew)BotaniaAPI.instance().getBrewRegistry().getOptional(brewId).orElseThrow(() -> new JsonParseException("Unknown brew " + brewStr));
            JsonArray ingrs = GsonHelper.getAsJsonArray((JsonObject)json, (String)"ingredients");
            ArrayList<Ingredient> inputs = new ArrayList<Ingredient>();
            for (JsonElement e : ingrs) {
                inputs.add(Ingredient.fromJson((JsonElement)e));
            }
            return new BotanicalBreweryRecipe(id, brew, inputs.toArray(new Ingredient[0]));
        }

        public BotanicalBreweryRecipe fromNetwork(@NotNull ResourceLocation id, @NotNull FriendlyByteBuf buf) {
            ResourceLocation brewId = buf.readResourceLocation();
            Brew brew = (Brew)BotaniaAPI.instance().getBrewRegistry().get(brewId);
            Ingredient[] inputs = new Ingredient[buf.readVarInt()];
            for (int i = 0; i < inputs.length; ++i) {
                inputs[i] = Ingredient.fromNetwork((FriendlyByteBuf)buf);
            }
            return new BotanicalBreweryRecipe(id, brew, inputs);
        }

        public void toNetwork(@NotNull FriendlyByteBuf buf, @NotNull BotanicalBreweryRecipe recipe) {
            ResourceLocation brewId = BotaniaAPI.instance().getBrewRegistry().getKey((Object)recipe.getBrew());
            buf.writeResourceLocation(brewId);
            buf.writeVarInt(recipe.getIngredients().size());
            for (Ingredient input : recipe.getIngredients()) {
                input.toNetwork(buf);
            }
        }
    }
}

