/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.common.block.BotaniaWaterloggedBlock;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.IncensePlateBlockEntity;
import vazkii.botania.xplat.XplatAbstractions;

public class IncensePlateBlock
extends BotaniaWaterloggedBlock
implements EntityBlock {
    private static final VoxelShape X_SHAPE = IncensePlateBlock.box((double)6.0, (double)0.0, (double)2.0, (double)10.0, (double)1.0, (double)14.0);
    private static final VoxelShape Z_SHAPE = IncensePlateBlock.box((double)2.0, (double)0.0, (double)6.0, (double)14.0, (double)1.0, (double)10.0);

    protected IncensePlateBlock(BlockBehaviour.Properties builder) {
        super(builder);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING});
    }

    public InteractionResult use(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        IncensePlateBlockEntity plate = (IncensePlateBlockEntity)world.getBlockEntity(pos);
        ItemStack plateStack = plate.getItemHandler().getItem(0);
        ItemStack stack = player.getItemInHand(hand);
        boolean did = false;
        if (plateStack.isEmpty() && plate.acceptsItem(stack)) {
            plate.getItemHandler().setItem(0, stack.copy());
            world.gameEvent(null, GameEvent.BLOCK_CHANGE, pos);
            stack.shrink(1);
            did = true;
        } else if (!plateStack.isEmpty() && !plate.burning) {
            if (XplatAbstractions.INSTANCE.canToolLightFire(stack)) {
                plate.ignite();
                world.playSound(player, pos, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 1.0f, world.getRandom().nextFloat() * 0.4f + 0.8f);
                stack.hurtAndBreak(1, (LivingEntity)player, e -> e.broadcastBreakEvent(hand));
            } else if (stack.is(Items.FIRE_CHARGE)) {
                plate.ignite();
                RandomSource randomsource = world.getRandom();
                world.playSound(player, pos, SoundEvents.FIRECHARGE_USE, SoundSource.BLOCKS, 1.0f, (randomsource.nextFloat() - randomsource.nextFloat()) * 0.2f + 1.0f);
                if (!player.getAbilities().instabuild) {
                    stack.shrink(1);
                }
            } else {
                player.getInventory().placeItemBackInInventory(plateStack);
                plate.getItemHandler().setItem(0, ItemStack.EMPTY);
                world.gameEvent(null, GameEvent.BLOCK_CHANGE, pos);
            }
            did = true;
        }
        if (did) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(plate);
            plate.setChanged();
        }
        return did ? InteractionResult.sidedSuccess((boolean)world.isClientSide()) : InteractionResult.PASS;
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    @NotNull
    public BlockState mirror(@NotNull BlockState state, Mirror mirror) {
        return (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)mirror.mirror((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
    }

    @NotNull
    public BlockState rotate(@NotNull BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        return ((IncensePlateBlockEntity)world.getBlockEntity((BlockPos)pos)).comparatorOutput;
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        if (((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getAxis() == Direction.Axis.X) {
            return X_SHAPE;
        }
        return Z_SHAPE;
    }

    @NotNull
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new IncensePlateBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return IncensePlateBlock.createTickerHelper(type, BotaniaBlockEntities.INCENSE_PLATE, IncensePlateBlockEntity::commonTick);
    }

    public void onRemove(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        BlockEntity block;
        if (!state.is(newState.getBlock()) && (block = world.getBlockEntity(pos)) instanceof IncensePlateBlockEntity) {
            IncensePlateBlockEntity plate = (IncensePlateBlockEntity)block;
            if (!plate.burning) {
                Containers.dropContents((Level)world, (BlockPos)pos, (Container)plate.getItemHandler());
            }
        }
        super.onRemove(state, world, pos, newState, isMoving);
    }

    public void onProjectileHit(@NotNull Level level, @NotNull BlockState blockState, @NotNull BlockHitResult hit, @NotNull Projectile projectile) {
        BlockEntity blockEntity;
        if (!level.isClientSide && projectile.mayInteract(level, hit.getBlockPos()) && projectile.isOnFire() && (blockEntity = level.getBlockEntity(hit.getBlockPos())) instanceof IncensePlateBlockEntity) {
            IncensePlateBlockEntity plate = (IncensePlateBlockEntity)blockEntity;
            plate.ignite();
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(plate);
        }
    }
}

