/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.advancements;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class LokiPlaceTrigger
extends SimpleCriterionTrigger<Instance> {
    public static final ResourceLocation ID = ResourceLocationHelper.prefix("loki_placed_blocks");
    public static final LokiPlaceTrigger INSTANCE = new LokiPlaceTrigger();

    private LokiPlaceTrigger() {
    }

    @NotNull
    public ResourceLocation getId() {
        return ID;
    }

    @NotNull
    public Instance createInstance(@NotNull JsonObject json, ContextAwarePredicate playerPred, DeserializationContext conditions) {
        return new Instance(playerPred, EntityPredicate.fromJson((JsonElement)json.get("player")), ItemPredicate.fromJson((JsonElement)json.get("ring")), MinMaxBounds.Ints.fromJson((JsonElement)json.get("blocks_placed")));
    }

    public void trigger(ServerPlayer player, ItemStack ring, int blocksPlaced) {
        this.trigger(player, instance -> instance.test(player, ring, blocksPlaced));
    }

    public static class Instance
    extends AbstractCriterionTriggerInstance {
        private final EntityPredicate player;
        private final ItemPredicate ring;
        private final MinMaxBounds.Ints blocksPlaced;

        public Instance(ContextAwarePredicate playerPred, EntityPredicate player, ItemPredicate ring, MinMaxBounds.Ints blocksPlaced) {
            super(ID, playerPred);
            this.player = player;
            this.ring = ring;
            this.blocksPlaced = blocksPlaced;
        }

        @NotNull
        public ResourceLocation getCriterion() {
            return ID;
        }

        boolean test(ServerPlayer player, ItemStack ring, int blocksPlaced) {
            return this.player.matches(player, null) && this.ring.matches(ring) && this.blocksPlaced.matches(blocksPlaced);
        }

        public JsonObject serializeToJson(SerializationContext context) {
            JsonObject json = super.serializeToJson(context);
            if (this.ring != ItemPredicate.ANY) {
                json.add("ring", this.ring.serializeToJson());
            }
            if (this.blocksPlaced != MinMaxBounds.Ints.ANY) {
                json.add("blocks_placed", this.blocksPlaced.serializeToJson());
            }
            return json;
        }

        public EntityPredicate getPlayer() {
            return this.player;
        }

        public ItemPredicate getRing() {
            return this.ring;
        }

        public MinMaxBounds.Ints getBlocksPlaced() {
            return this.blocksPlaced;
        }
    }
}

