/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import vazkii.botania.client.core.handler.MiscellaneousModels;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.entity.BabylonWeaponEntity;
import vazkii.botania.common.helper.VecHelper;

public class BabylonWeaponRenderer
extends EntityRenderer<BabylonWeaponEntity> {
    public BabylonWeaponRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
    }

    public void render(@NotNull BabylonWeaponEntity weapon, float yaw, float partialTicks, PoseStack ms, MultiBufferSource buffers, int light) {
        ms.pushPose();
        ms.mulPose(VecHelper.rotateY(weapon.getRotation()));
        int live = weapon.getLiveTicks();
        int delay = weapon.getDelay();
        float charge = Math.min(10.0f, (float)Math.max(live, weapon.getChargeTicks()) + partialTicks);
        float chargeMul = charge / 10.0f;
        ms.pushPose();
        ms.translate(-0.75, 0.0, 1.0);
        float s = 1.5f;
        ms.scale(s, s, s);
        ms.mulPose(VecHelper.rotateY(90.0f));
        ms.mulPose(VecHelper.rotateZ(-45.0f));
        BakedModel model = MiscellaneousModels.INSTANCE.kingKeyWeaponModels[weapon.getVariety()];
        Minecraft.getInstance().getBlockRenderer().getModelRenderer().renderModel(ms.last(), buffers.getBuffer(Sheets.translucentItemSheet()), null, model, 1.0f, 1.0f, 1.0f, 0xF000F0, OverlayTexture.NO_OVERLAY);
        ms.popPose();
        Random rand = new Random(weapon.getUUID().getMostSignificantBits());
        ms.mulPose(VecHelper.rotateX(-90.0f));
        ms.translate(0.0f, -0.3f + rand.nextFloat() * 0.1f, 0.0f);
        s = chargeMul;
        if (live > delay) {
            s -= Math.min(1.0f, ((float)(live - delay) + partialTicks) * 0.2f);
        }
        ms.scale(s *= 2.0f, s, s);
        ms.mulPose(VecHelper.rotateY(charge * 9.0f + ((float)weapon.tickCount + partialTicks) * 0.5f + rand.nextFloat() * 360.0f));
        VertexConsumer buffer = buffers.getBuffer(RenderHelper.BABYLON_ICON);
        Matrix4f mat = ms.last().pose();
        buffer.vertex(mat, -1.0f, 0.0f, -1.0f).color(1.0f, 1.0f, 1.0f, chargeMul).uv(0.0f, 0.0f).endVertex();
        buffer.vertex(mat, -1.0f, 0.0f, 1.0f).color(1.0f, 1.0f, 1.0f, chargeMul).uv(0.0f, 1.0f).endVertex();
        buffer.vertex(mat, 1.0f, 0.0f, 1.0f).color(1.0f, 1.0f, 1.0f, chargeMul).uv(1.0f, 1.0f).endVertex();
        buffer.vertex(mat, 1.0f, 0.0f, -1.0f).color(1.0f, 1.0f, 1.0f, chargeMul).uv(1.0f, 0.0f).endVertex();
        ms.popPose();
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull BabylonWeaponEntity entity) {
        return InventoryMenu.BLOCK_ATLAS;
    }
}

