/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.common.crafting.recipe.NbtOutputRecipe;

public class NbtOutputResult
implements FinishedRecipe {
    private final FinishedRecipe innerRecipe;
    private final CompoundTag tag;

    public NbtOutputResult(FinishedRecipe innerRecipe, CompoundTag tag) {
        this.innerRecipe = innerRecipe;
        this.tag = tag;
    }

    public static Consumer<FinishedRecipe> with(Consumer<FinishedRecipe> parent, Consumer<CompoundTag> tagSetup) {
        CompoundTag tag = new CompoundTag();
        tagSetup.accept(tag);
        return recipe -> parent.accept(new NbtOutputResult((FinishedRecipe)recipe, tag));
    }

    public void serializeRecipeData(JsonObject json) {
        json.add("recipe", (JsonElement)this.innerRecipe.serializeRecipe());
        json.addProperty("nbt", this.tag.toString());
    }

    public ResourceLocation getId() {
        return this.innerRecipe.getId();
    }

    public RecipeSerializer<?> getType() {
        return NbtOutputRecipe.SERIALIZER;
    }

    @Nullable
    public JsonObject serializeAdvancement() {
        return this.innerRecipe.serializeAdvancement();
    }

    @Nullable
    public ResourceLocation getAdvancementId() {
        return this.innerRecipe.getAdvancementId();
    }
}

