/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import net.minecraft.commands.CommandFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block_entity.SpecialFlowerBlockEntity;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.common.crafting.PureDaisyRecipe;
import vazkii.botania.common.crafting.StateIngredientHelper;

public class StateCopyingPureDaisyRecipe
extends PureDaisyRecipe {
    public StateCopyingPureDaisyRecipe(ResourceLocation id, StateIngredient input, Block block, int time) {
        super(id, input, block.defaultBlockState(), time, CommandFunction.CacheableFunction.NONE);
    }

    @Override
    public boolean matches(Level world, BlockPos pos, SpecialFlowerBlockEntity pureDaisy, BlockState state) {
        return this.input.test(state) && this.outputState.getBlock().withPropertiesOf(state) != state;
    }

    @Override
    public boolean set(Level world, BlockPos pos, SpecialFlowerBlockEntity pureDaisy) {
        if (!world.isClientSide) {
            Block block = this.getOutputState().getBlock();
            world.setBlockAndUpdate(pos, block.withPropertiesOf(world.getBlockState(pos)));
        }
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<StateCopyingPureDaisyRecipe> {
        @NotNull
        public StateCopyingPureDaisyRecipe fromJson(@NotNull ResourceLocation id, JsonObject object) {
            StateIngredient input = StateIngredientHelper.deserialize(GsonHelper.getAsJsonObject((JsonObject)object, (String)"input"));
            ResourceLocation blockId = new ResourceLocation(GsonHelper.getAsString((JsonObject)object, (String)"output"));
            Block output = (Block)BuiltInRegistries.BLOCK.getOptional(blockId).orElseThrow(() -> new JsonSyntaxException("Unknown block id: " + blockId));
            int time = GsonHelper.getAsInt((JsonObject)object, (String)"time", (int)150);
            return new StateCopyingPureDaisyRecipe(id, input, output, time);
        }

        public void toNetwork(@NotNull FriendlyByteBuf buf, StateCopyingPureDaisyRecipe recipe) {
            recipe.getInput().write(buf);
            buf.writeVarInt(BuiltInRegistries.BLOCK.getId((Object)recipe.getOutputState().getBlock()));
            buf.writeVarInt(recipe.getTime());
        }

        @Nullable
        public StateCopyingPureDaisyRecipe fromNetwork(@NotNull ResourceLocation id, @NotNull FriendlyByteBuf buf) {
            StateIngredient input = StateIngredientHelper.read(buf);
            Block output = (Block)BuiltInRegistries.BLOCK.byId(buf.readVarInt());
            int time = buf.readVarInt();
            return new StateCopyingPureDaisyRecipe(id, input, output, time);
        }
    }
}

