/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.flower.functional;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block.Wandable;
import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.helper.DelayHelper;
import vazkii.botania.network.clientbound.ItemAgePacket;
import vazkii.botania.xplat.XplatAbstractions;

public class DaffomillBlockEntity
extends FunctionalFlowerBlockEntity
implements Wandable {
    private static final String TAG_ORIENTATION = "orientation";
    private static final String TAG_WIND_TICKS = "windTicks";
    private static final String TAG_POWERED = "powered";
    private int windTicks = 0;
    private Direction orientation = Direction.NORTH;
    private boolean redstonePowered;

    public DaffomillBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaFlowerBlocks.DAFFOMILL, pos, state);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (this.getLevel().random.nextInt(4) == 0) {
            WispParticleData data = WispParticleData.wisp(0.25f + (float)Math.random() * 0.15f, 0.05f, 0.05f, 0.05f);
            this.emitParticle(data, Math.random(), Math.random(), Math.random(), (float)this.orientation.getStepX() * 0.1f, (float)this.orientation.getStepY() * 0.1f, (float)this.orientation.getStepZ() * 0.1f);
        }
        if (this.windTicks == 0 && this.getMana() > 0) {
            this.windTicks = 20;
            this.addMana(-1);
        }
        if (this.windTicks > 0 && !this.isRedstonePowered()) {
            AABB axis = this.aabbForOrientation();
            if (axis != null) {
                List items = this.getLevel().getEntitiesOfClass(ItemEntity.class, axis);
                for (ItemEntity item : items) {
                    if (!DelayHelper.canInteractWithImmediate(this, item)) continue;
                    item.setDeltaMovement(item.getDeltaMovement().x() + (double)this.orientation.getStepX() * 0.05, item.getDeltaMovement().y() + (double)this.orientation.getStepY() * 0.05, item.getDeltaMovement().z() + (double)this.orientation.getStepZ() * 0.05);
                }
            }
            --this.windTicks;
        }
    }

    private AABB aabbForOrientation() {
        int x = this.getEffectivePos().getX();
        int y = this.getEffectivePos().getY();
        int z = this.getEffectivePos().getZ();
        int w = 2;
        int h = 3;
        int l = 16;
        AABB axis = null;
        switch (this.orientation) {
            case NORTH: {
                axis = new AABB((double)(x - w), (double)(y - h), (double)(z - l), (double)(x + w + 1), (double)(y + h), (double)z);
                break;
            }
            case SOUTH: {
                axis = new AABB((double)(x - w), (double)(y - h), (double)(z + 1), (double)(x + w + 1), (double)(y + h), (double)(z + l + 1));
                break;
            }
            case WEST: {
                axis = new AABB((double)(x - l), (double)(y - h), (double)(z - w), (double)x, (double)(y + h), (double)(z + w + 1));
                break;
            }
            case EAST: {
                axis = new AABB((double)(x + 1), (double)(y - h), (double)(z - w), (double)(x + l + 1), (double)(y + h), (double)(z + w + 1));
                break;
            }
        }
        return axis;
    }

    @Override
    public boolean acceptsRedstone() {
        return true;
    }

    @Override
    public boolean onUsedByWand(@Nullable Player player, ItemStack wand, Direction side) {
        if (player == null || !player.isShiftKeyDown()) {
            return false;
        }
        if (!player.level().isClientSide) {
            this.orientation = this.orientation.getClockWise();
            this.sync();
        }
        return true;
    }

    @Override
    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (placer != null) {
            this.orientation = placer.getDirection();
        }
        super.setPlacedBy(level, pos, state, placer, stack);
    }

    @Override
    public RadiusDescriptor getRadius() {
        AABB aabb = this.aabbForOrientation();
        aabb = new AABB(aabb.minX, (double)this.getEffectivePos().getY(), aabb.minZ, aabb.maxX, aabb.maxY, aabb.maxZ);
        return new RadiusDescriptor.Rectangle(this.getEffectivePos(), aabb);
    }

    @Override
    public int getColor() {
        return 14203392;
    }

    @Override
    public int getMaxMana() {
        return 100;
    }

    @Override
    public void writeToPacketNBT(CompoundTag cmp) {
        super.writeToPacketNBT(cmp);
        cmp.putInt(TAG_ORIENTATION, this.orientation.get3DDataValue());
        cmp.putInt(TAG_WIND_TICKS, this.windTicks);
        cmp.putBoolean(TAG_POWERED, this.redstonePowered);
    }

    @Override
    public void readFromPacketNBT(CompoundTag cmp) {
        super.readFromPacketNBT(cmp);
        this.orientation = Direction.from3DDataValue((int)cmp.getInt(TAG_ORIENTATION));
        this.windTicks = cmp.getInt(TAG_WIND_TICKS);
        this.redstonePowered = cmp.getBoolean(TAG_POWERED);
    }

    private boolean isRedstonePowered() {
        if (!this.level.isClientSide) {
            boolean powered;
            boolean bl = powered = this.redstoneSignal != 0;
            if (powered != this.redstonePowered) {
                this.redstonePowered = powered;
                this.sync();
            }
        }
        return this.redstonePowered;
    }

    public static void onItemTrack(Entity entity, ServerPlayer player) {
        if (entity instanceof ItemEntity) {
            ItemEntity item = (ItemEntity)entity;
            int entityId = entity.getId();
            int age = XplatAbstractions.INSTANCE.itemFlagsComponent((ItemEntity)item).timeCounter;
            XplatAbstractions.INSTANCE.sendToPlayer((Player)player, new ItemAgePacket(entityId, age));
        }
    }
}

