/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.block_entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.inventory.InventoryMenu;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.block.block_entity.TerrestrialAgglomerationPlateBlockEntity;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class TerrestrialAgglomerationPlateBlockEntityRenderer
implements BlockEntityRenderer<TerrestrialAgglomerationPlateBlockEntity> {
    private final TextureAtlasSprite overlaySprite = Objects.requireNonNull((TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(ResourceLocationHelper.prefix("block/terra_plate_overlay")));

    public TerrestrialAgglomerationPlateBlockEntityRenderer(BlockEntityRendererProvider.Context manager) {
    }

    public void render(@NotNull TerrestrialAgglomerationPlateBlockEntity plate, float f, PoseStack ms, MultiBufferSource buffers, int light, int overlay) {
        float alphaMod = Math.min(1.0f, plate.getCompletion() / 0.1f);
        ms.pushPose();
        ms.translate(0.0f, 0.1885f, 0.0f);
        ms.mulPose(VecHelper.rotateX(90.0f));
        float alpha = (float)((Math.sin((double)((float)ClientTickHandler.ticksInGame + f) / 8.0) + 1.0) / 5.0 + 0.6) * alphaMod;
        VertexConsumer buffer = buffers.getBuffer(RenderHelper.TERRA_PLATE);
        RenderHelper.renderIconFullBright(ms, buffer, this.overlaySprite, alpha);
        ms.popPose();
    }
}

