/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.xplat.BotaniaConfig;

public final class ManaTabletRenderHandler
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    public ManaTabletRenderHandler(RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> renderer) {
        super(renderer);
    }

    public void render(PoseStack ms, MultiBufferSource buffers, int light, @NotNull AbstractClientPlayer player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (BotaniaConfig.client().renderAccessories() && !player.isInvisible()) {
            this.renderManaTablet(ms, buffers, (Player)player);
        }
    }

    private void renderManaTablet(PoseStack ms, MultiBufferSource buffers, Player player) {
        boolean renderedOne = false;
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack stack = player.getInventory().getItem(i);
            if (stack.isEmpty() || !stack.is(BotaniaItems.manaTablet)) continue;
            ms.pushPose();
            boolean armor = !player.getItemBySlot(EquipmentSlot.LEGS).isEmpty();
            ((PlayerModel)this.getParentModel()).body.translateAndRotate(ms);
            ms.translate(0.0, 0.65, 0.0);
            if (renderedOne) {
                ms.translate(armor ? 0.3 : 0.25, 0.0, 0.0);
                ms.mulPose(VecHelper.rotateY(-90.0f));
            } else {
                ms.translate(armor ? -0.3 : -0.25, 0.0, 0.0);
                ms.mulPose(VecHelper.rotateY(90.0f));
            }
            ms.scale(0.375f, -0.375f, -0.375f);
            Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.NONE, 0xF000F0, OverlayTexture.NO_OVERLAY, ms, buffers, player.level(), player.getId());
            ms.popPose();
            if (renderedOne) {
                return;
            }
            renderedOne = true;
        }
    }
}

