/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.entity.ManaStormEntity;

public class ManaStormRenderer
extends EntityRenderer<ManaStormEntity> {
    public ManaStormRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
    }

    public void render(ManaStormEntity storm, float yaw, float pticks, PoseStack ms, MultiBufferSource buffers, int light) {
        ms.pushPose();
        float maxScale = 1.95f;
        float scale = 0.05f + ((float)storm.burstsFired / 250.0f - (storm.deathTime == 0 ? 0.0f : (float)storm.deathTime + pticks) / 200.0f) * maxScale;
        RenderHelper.renderStar(ms, buffers, 65280, scale, scale, scale, storm.getUUID().getMostSignificantBits());
        ms.popPose();
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull ManaStormEntity entity) {
        return InventoryMenu.BLOCK_ATLAS;
    }
}

